/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.floating.IEEEFloatType;
import com.clarkparsia.pellet.datatypes.types.floating.RestrictedFloatingPointDatatype;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDFloat
extends AbstractBaseDatatype<Float> {
    private static final XSDFloat instance = new XSDFloat();
    private final RestrictedFloatingPointDatatype<Float> dataRange = new RestrictedFloatingPointDatatype<Float>(this, IEEEFloatType.getInstance());

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        super(ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#float"));
    }

    @Override
    public RestrictedDatatype<Float> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        Float f = this.getValue(input);
        String canonicalForm = DatatypeConverter.printFloat((float)f.floatValue());
        if (canonicalForm.equals(ATermUtils.getLiteralValue((ATermAppl)input))) {
            return input;
        }
        return ATermUtils.makeTypedLiteral((String)canonicalForm, (ATermAppl)this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Float) {
            return ATermUtils.makeTypedLiteral((String)DatatypeConverter.printFloat((float)((Float)value).floatValue()), (ATermAppl)this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        try {
            return Float.valueOf(DatatypeConverter.parseFloat((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

