/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDInt
extends AbstractDerivedIntegerType {
    private static final XSDInt instance = new XSDInt();

    public static XSDInt getInstance() {
        return instance;
    }

    private XSDInt() {
        super(ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#int"), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            long n = DatatypeConverter.parseLong((String)lexicalForm);
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (int)n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

