/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDNonPositiveInteger
extends AbstractDerivedIntegerType {
    private static final XSDNonPositiveInteger instance = new XSDNonPositiveInteger();

    public static XSDNonPositiveInteger getInstance() {
        return instance;
    }

    private XSDNonPositiveInteger() {
        super(ATermUtils.makeTermAppl((String)"http://www.w3.org/2001/XMLSchema#nonPositiveInteger"), null, 0);
    }

    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

