/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedTextDatatype
implements RestrictedDatatype<ATermAppl> {
    private static final String NCNAMESTARTCHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NCNAMECHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NCNAME = "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    private static final String NAMESTARTCHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NAMECHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NAME = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    protected static final String NMTOKEN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    protected static final String TOKEN = "([^\\s])(\\s([^\\s])|([^\\s]))*";
    protected static final String LANGUAGE = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    protected static final String NORMALIZED_STRING = "([^\\r\\n\\t])*";
    private static final Set<ATermAppl> permittedDts = new HashSet<ATermAppl>(Arrays.asList(ATermUtils.EMPTY));
    private final Set<Object> excludedValues;
    private final Set<Pattern> patterns;
    private final boolean allowLang;
    private final Datatype<ATermAppl> dt;

    public static boolean addPermittedDatatype(ATermAppl dt) {
        return permittedDts.add(dt);
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> dt, boolean allowLang) {
        this(dt, Collections.emptySet(), allowLang, Collections.emptySet());
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> dt, String pattern) {
        this(dt, Collections.singleton(Pattern.compile(pattern)), false, Collections.emptySet());
    }

    private RestrictedTextDatatype(Datatype<ATermAppl> dt, Set<Pattern> patterns, boolean allowLang, Set<Object> excludedValues) {
        this.dt = dt;
        this.allowLang = allowLang;
        this.excludedValues = excludedValues;
        this.patterns = patterns;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)value;
            if (this.excludedValues.contains(a)) {
                return false;
            }
            if (ATermUtils.isLiteral((ATermAppl)a) && permittedDts.contains(a.getArgument(2))) {
                if (!this.allowLang && !ATermUtils.EMPTY.equals(a.getArgument(1))) {
                    return false;
                }
                if (!this.patterns.isEmpty()) {
                    String litValue = ((ATermAppl)a.getArgument(0)).getName();
                    for (Pattern pattern : this.patterns) {
                        if (pattern.matcher(litValue).matches()) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> values) {
        HashSet<Object> newExcludedValues = new HashSet<Object>(values);
        newExcludedValues.addAll(this.excludedValues);
        return new RestrictedTextDatatype(this.dt, this.patterns, this.allowLang, newExcludedValues);
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this.dt;
    }

    @Override
    public ATermAppl getValue(int i) {
        throw new UnsupportedOperationException();
    }

    protected <T> List<T> concatLists(List<T> l1, List<T> l2) {
        if (l1.isEmpty()) {
            return l2;
        }
        if (l2.isEmpty()) {
            return l1;
        }
        ArrayList<T> newList = new ArrayList<T>(l1.size() + l2.size());
        newList.addAll(l1);
        newList.addAll(l2);
        return newList;
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedTextDatatype) {
            RestrictedTextDatatype that = (RestrictedTextDatatype)other;
            return new RestrictedTextDatatype(this.dt, SetUtils.union(this.patterns, that.patterns), this.allowLang && that.allowLang, SetUtils.union(this.excludedValues, that.excludedValues));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedTextDatatype) {
            if (!this.patterns.isEmpty() || !((RestrictedTextDatatype)other).patterns.isEmpty()) {
                throw new UnsupportedOperationException();
            }
            if (this.allowLang) {
                return this;
            }
            return (RestrictedTextDatatype)other;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }
}

