/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ConceptInfo;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.el.ELTaxonomyBuilder;
import com.clarkparsia.pellet.el.RoleChainCache;
import com.clarkparsia.pellet.el.RoleRestrictionCache;
import com.clarkparsia.pellet.el.Trigger;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.POTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.mindswap.pellet.utils.PartialOrderRelation;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELClassifier
extends CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    public static final Logger logger = Logger.getLogger(ELClassifier.class.getName());
    public final Timers timers = new Timers();
    public ConceptInfo TOP;
    public ConceptInfo BOTTOM;
    private boolean hasComplexRoles;
    private MultiValueMap<ConceptInfo, Trigger> queue;
    private Map<ATermAppl, ConceptInfo> concepts;
    private RoleChainCache roleChains;
    private RoleRestrictionCache roleRestrictions;
    private PartialOrderComparator<ATermAppl> subsumptionComparator = new PartialOrderComparator<ATermAppl>(){

        public PartialOrderRelation compare(ATermAppl a, ATermAppl b) {
            ConceptInfo bInfo;
            ConceptInfo aInfo = ELClassifier.this.getInfo(a);
            if (aInfo.hasSuperClass(bInfo = ELClassifier.this.getInfo(b))) {
                if (bInfo.hasSuperClass(aInfo)) {
                    return PartialOrderRelation.EQUAL;
                }
                return PartialOrderRelation.LESS;
            }
            if (bInfo.hasSuperClass(aInfo)) {
                return PartialOrderRelation.GREATER;
            }
            return PartialOrderRelation.INCOMPARABLE;
        }
    };

    protected void reset() {
        super.reset();
        this.hasComplexRoles = this.kb.getExpressivity().hasTransitivity() || this.kb.getExpressivity().hasComplexSubRoles();
        this.queue = new MultiValueMap();
        this.concepts = CollectionUtils.makeMap();
        this.roleChains = new RoleChainCache(this.kb);
        this.roleRestrictions = new RoleRestrictionCache(this.kb.getRBox());
    }

    public boolean classify() {
        this.reset();
        this.kb.prepare();
        Timer t = this.timers.startTimer("createConcepts");
        logger.info("Creating structures");
        this.createConcepts();
        logger.info("Created structures");
        t.stop();
        this.monitor.setProgressTitle("Classifiying");
        this.monitor.setProgressLength(this.queue.size());
        this.monitor.taskStarted();
        this.printStructures();
        logger.info("Processing queue");
        t = this.timers.startTimer("processQueue");
        this.processQueue();
        t.stop();
        logger.info("Processed queue");
        if (logger.isLoggable(Level.FINE)) {
            this.print();
        }
        logger.info("Building hierarchy");
        t = this.timers.startTimer("buildHierarchy");
        this.taxonomy = new ELTaxonomyBuilder().build(this.concepts);
        t.stop();
        logger.info("Builded hierarchy");
        this.monitor.taskFinished();
        return true;
    }

    private void buildTaxonomyWithPO() {
        POTaxonomyBuilder builder = new POTaxonomyBuilder(this.kb, this.subsumptionComparator);
        this.taxonomy = builder.getTaxonomy();
        for (ConceptInfo ci : this.concepts.values()) {
            this.classify(ci);
        }
    }

    private void classify(ConceptInfo ci) {
        ATermAppl c = ci.getConcept();
        if (!ATermUtils.isPrimitive((ATermAppl)c)) {
            return;
        }
        if (ci.getSuperClasses().contains(this.BOTTOM)) {
            this.taxonomy.addEquivalentNode((Object)c, this.taxonomy.getBottom());
            return;
        }
        HashSet<ATermAppl> equivalents = new HashSet<ATermAppl>();
        for (ConceptInfo subsumer : ci.getSuperClasses()) {
            if (!ATermUtils.isPrimitive((ATermAppl)subsumer.getConcept()) || ci.equals(subsumer)) continue;
            if (subsumer.hasSuperClass(ci)) {
                equivalents.add(subsumer.getConcept());
                continue;
            }
            this.classify(subsumer);
        }
        this.taxonomy.addEquivalents((Object)c, equivalents);
    }

    private void addExistential(ConceptInfo ci, ATermAppl prop, ConceptInfo qi) {
        if (ci.hasSuccessor(prop, qi)) {
            return;
        }
        this.addExistentialP(ci, prop, qi);
        Set supEqs = this.kb.getSuperProperties(prop);
        for (Set supEq : supEqs) {
            for (ATermAppl sup : supEq) {
                this.addExistentialP(ci, sup, qi);
            }
        }
    }

    private void addExistentialP(ConceptInfo ci, ATermAppl prop, ConceptInfo qi) {
        ATermAppl propRange;
        ATermAppl some;
        ConceptInfo si;
        if (ci.hasSuccessor(prop, qi)) {
            return;
        }
        for (ConceptInfo supInfo : qi.getSuperClasses()) {
            if (!ci.addSuccessor(prop, supInfo)) continue;
            if (supInfo.equals(this.BOTTOM)) {
                this.addSubsumer(ci, this.BOTTOM);
                Iterator preds = ci.getPredecessors().flattenedValues();
                while (preds.hasNext()) {
                    this.addSubsumer((ConceptInfo)preds.next(), this.BOTTOM);
                }
            }
            if ((si = this.getInfo(some = ATermUtils.makeSomeValues((ATerm)prop, (ATerm)supInfo.getConcept()))) == null) continue;
            this.addToQueue(ci, si.getTriggers());
        }
        ATermAppl q = qi.getConcept();
        if (ATermUtils.isAnd((ATermAppl)q)) {
            ATermList list = (ATermList)q.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                ConceptInfo conjInfo = this.createConcept(conj);
                if (ci.addSuccessor(prop, conjInfo)) {
                    ATermAppl some2 = ATermUtils.makeSomeValues((ATerm)prop, (ATerm)conj);
                    ConceptInfo si2 = this.createConcept(some2);
                    this.addToQueue(ci, si2.getTriggers());
                }
                list = list.getNext();
            }
        }
        if ((propRange = this.roleRestrictions.getRange(prop)) != null) {
            some = ATermUtils.makeSomeValues((ATerm)prop, (ATerm)propRange);
            si = this.createConcept(some);
            this.addSubsumer(ci, si);
        }
        if (this.hasComplexRoles) {
            for (Map.Entry entry : ci.getPredecessors().entrySet()) {
                ATermAppl predProp = (ATermAppl)entry.getKey();
                for (ConceptInfo pred : (Set)entry.getValue()) {
                    for (ATermAppl supProp : this.roleChains.getAllSuperRoles(predProp, prop)) {
                        this.addExistential(pred, supProp, qi);
                    }
                }
            }
            for (Map.Entry entry : qi.getSuccessors().entrySet()) {
                ATermAppl succProp = (ATermAppl)entry.getKey();
                for (ConceptInfo succ : (Set)entry.getValue()) {
                    for (ATermAppl supProp : this.roleChains.getAllSuperRoles(prop, succProp)) {
                        this.addExistential(ci, supProp, succ);
                    }
                }
            }
        }
    }

    private void addToQueue(ConceptInfo ci, Set<Trigger> triggers) {
        if (this.queue.addAll((Object)ci, triggers) && logger.isLoggable(Level.FINE)) {
            logger.fine("Add to queue: " + ci + " " + triggers);
        }
    }

    private void addSubsumer(ConceptInfo ci, ConceptInfo supInfo) {
        if (ci.hasSuperClass(supInfo)) {
            return;
        }
        ci.addSuperClass(supInfo);
        if (ATermUtils.isBottom((ATermAppl)supInfo.getConcept())) {
            Iterator preds = ci.getPredecessors().flattenedValues();
            while (preds.hasNext()) {
                this.addSubsumer((ConceptInfo)preds.next(), supInfo);
            }
            return;
        }
        this.addToQueue(ci, supInfo.getTriggers());
        ATermAppl c = supInfo.getConcept();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding subsumers to " + ci + " " + c + " " + ci.getSuperClasses());
        }
        if (ATermUtils.isAnd((ATermAppl)c)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.addSubsumer(ci, this.createConcept(conj));
                list = list.getNext();
            }
        } else if (ATermUtils.isSomeValues((ATermAppl)c)) {
            ATermAppl p = (ATermAppl)c.getArgument(0);
            ATermAppl qualification = (ATermAppl)c.getArgument(1);
            ConceptInfo q = this.createConcept(qualification);
            this.addExistential(ci, p, q);
        } else assert (ATermUtils.isPrimitive((ATermAppl)c));
        for (Map.Entry e : ci.getPredecessors().entrySet()) {
            ATermAppl prop = (ATermAppl)e.getKey();
            for (ConceptInfo pred : (Set)e.getValue()) {
                ATermAppl some = ATermUtils.makeSomeValues((ATerm)prop, (ATerm)c);
                ConceptInfo si = this.getInfo(some);
                if (si == null) continue;
                this.addToQueue(pred, si.getTriggers());
            }
        }
    }

    private ConceptInfo createConcept(ATermAppl c) {
        ConceptInfo ci = this.getInfo(c);
        if (ci == null) {
            ci = new ConceptInfo(c, this.hasComplexRoles, false);
            this.concepts.put(c, ci);
            ci.addSuperClass(this.TOP);
            this.addSubsumer(ci, ci);
            if (ATermUtils.isAnd((ATermAppl)c)) {
                ConceptInfo[] conjuncts;
                for (ConceptInfo conjInfo : conjuncts = this.createConceptArray((ATermList)c.getArgument(0))) {
                    conjInfo.addTrigger(new Trigger(conjuncts, ci));
                }
            } else if (ATermUtils.isSomeValues((ATermAppl)c)) {
                ATermAppl q = (ATermAppl)c.getArgument(1);
                this.createConcept(q);
                ci.addTrigger(new Trigger(ci));
            }
        }
        return ci;
    }

    private ConceptInfo[] createConceptArray(ATermList list) {
        ConceptInfo[] a = new ConceptInfo[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            a[i++] = this.createConcept((ATermAppl)list.getFirst());
            list = list.getNext();
        }
        return a;
    }

    private void createConceptsFromAxiom(ATermAppl sub, ATermAppl sup) {
        ConceptInfo ciSub = this.createConcept(sub);
        ConceptInfo ciSup = this.createConcept(sup);
        Trigger trigger = new Trigger(ciSup);
        ciSub.addTrigger(trigger);
    }

    private void toELSubClassAxioms(ATermAppl axiom) {
        AFun fun = axiom.getAFun();
        ATermAppl sub = (ATermAppl)axiom.getArgument(0);
        ATermAppl sup = (ATermAppl)axiom.getArgument(1);
        ATermAppl subEL = ELSyntaxUtils.simplify(sub);
        if (fun.equals(ATermUtils.SUBFUN)) {
            if (ATermUtils.isPrimitive((ATermAppl)sup) || ATermUtils.isBottom((ATermAppl)sup)) {
                this.createConceptsFromAxiom(subEL, sup);
                return;
            }
            ATermAppl supEL = ELSyntaxUtils.simplify(sup);
            this.createConceptsFromAxiom(subEL, supEL);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl supEL = ELSyntaxUtils.simplify(sup);
            this.createConceptsFromAxiom(subEL, supEL);
            this.createConceptsFromAxiom(supEL, subEL);
        } else {
            throw new IllegalArgumentException("Axiom " + axiom + " is not EL.");
        }
    }

    private void normalizeAxioms() {
        Collection assertedAxioms = this.kb.getTBox().getAssertedAxioms();
        for (ATermAppl aTermAppl : assertedAxioms) {
            this.toELSubClassAxioms(aTermAppl);
        }
        for (Map.Entry entry : this.roleRestrictions.getDomains().entrySet()) {
            ATermAppl roleName = (ATermAppl)entry.getKey();
            ATermAppl domain = (ATermAppl)entry.getValue();
            this.createConceptsFromAxiom(ATermUtils.makeSomeValues((ATerm)roleName, (ATerm)ATermUtils.TOP), domain);
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            ATermAppl range;
            if (!role.isReflexive() || (range = this.roleRestrictions.getRange(role.getName())) == null) continue;
            this.createConceptsFromAxiom(ATermUtils.TOP, range);
        }
    }

    private void createConcepts() {
        this.TOP = new ConceptInfo(ATermUtils.TOP, this.hasComplexRoles, false);
        this.concepts.put(ATermUtils.TOP, this.TOP);
        this.TOP.addSuperClass(this.TOP);
        this.BOTTOM = new ConceptInfo(ATermUtils.BOTTOM, this.hasComplexRoles, false);
        this.concepts.put(ATermUtils.BOTTOM, this.BOTTOM);
        this.BOTTOM.addSuperClass(this.BOTTOM);
        for (ATermAppl c : this.kb.getClasses()) {
            this.createConcept(c);
        }
        this.normalizeAxioms();
        Set<Trigger> TOP_TRIGGERS = this.TOP.getTriggers();
        for (ConceptInfo ci : this.concepts.values()) {
            Set queueList = CollectionUtils.makeSet(TOP_TRIGGERS);
            queueList.addAll(ci.getTriggers());
            if (queueList.isEmpty()) continue;
            this.queue.addAll((Object)ci, (Collection)queueList);
        }
    }

    private ConceptInfo getInfo(ATermAppl concept) {
        return this.concepts.get(concept);
    }

    public void print() {
        for (ConceptInfo ci : this.concepts.values()) {
            System.out.println(ci + " " + ci.getSuperClasses());
        }
        System.out.println();
        this.roleChains.print();
    }

    public void printStructures() {
        if (logger.isLoggable(Level.FINE)) {
            for (ConceptInfo ci : this.concepts.values()) {
                logger.fine(ci + "\t" + ci.getTriggers() + "\t" + ci.getSuperClasses());
            }
        }
    }

    private void processQueue() {
        int startingSize = this.queue.size();
        while (!this.queue.isEmpty()) {
            int processed = startingSize - this.queue.size();
            if (this.monitor.getProgress() < processed) {
                this.monitor.setProgress(processed);
            }
            MultiValueMap<ConceptInfo, Trigger> localQueue = this.queue;
            this.queue = new MultiValueMap();
            for (Map.Entry entry : localQueue.entrySet()) {
                ConceptInfo ci = (ConceptInfo)entry.getKey();
                for (Trigger trigger : (Set)entry.getValue()) {
                    this.processTrigger(ci, trigger);
                }
            }
        }
    }

    private void processTrigger(ConceptInfo ci, Trigger trigger) {
        if (trigger.isTriggered(ci)) {
            this.addSubsumer(ci, trigger.getConsequence());
        }
    }
}

