/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTaxonomyBuilder {
    private Taxonomy<ATermAppl> taxonomy;
    private MultiValueMap<ATermAppl, ATermAppl> subsumers;

    public Taxonomy<ATermAppl> build(MultiValueMap<ATermAppl, ATermAppl> subsumers) {
        this.subsumers = subsumers;
        this.taxonomy = new Taxonomy(null, (Object)ATermUtils.TOP, (Object)ATermUtils.BOTTOM);
        for (ATermAppl subsumer : (Set)subsumers.get((Object)ATermUtils.TOP)) {
            if (!ATermUtils.isPrimitive((ATermAppl)subsumer)) continue;
            this.taxonomy.addEquivalentNode((Object)subsumer, this.taxonomy.getTop());
        }
        for (Map.Entry entry : subsumers.entrySet()) {
            ATermAppl c = (ATermAppl)entry.getKey();
            if (!ATermUtils.isPrimitive((ATermAppl)c)) continue;
            if (((Set)entry.getValue()).contains(ATermUtils.BOTTOM)) {
                this.taxonomy.addEquivalentNode((Object)c, this.taxonomy.getBottom());
                continue;
            }
            this.add(c);
        }
        return this.taxonomy;
    }

    private TaxonomyNode<ATermAppl> add(ATermAppl c) {
        TaxonomyNode<ATermAppl> node = this.taxonomy.getNode((Object)c);
        if (node == null) {
            Set equivalents = CollectionUtils.makeSet();
            Set subsumerNodes = CollectionUtils.makeSet();
            for (ATermAppl subsumer : (Set)this.subsumers.get((Object)c)) {
                if (c.equals(subsumer) || !ATermUtils.isPrimitive((ATermAppl)subsumer)) continue;
                if (((Set)this.subsumers.get((Object)subsumer)).contains(c)) {
                    equivalents.add(subsumer);
                    continue;
                }
                TaxonomyNode<ATermAppl> supNode = this.add(subsumer);
                subsumerNodes.add(supNode);
            }
            node = this.add(c, subsumerNodes);
            for (ATermAppl eq : equivalents) {
                this.taxonomy.addEquivalentNode((Object)eq, node);
            }
        }
        return node;
    }

    private TaxonomyNode<ATermAppl> add(ATermAppl c, Set<TaxonomyNode<ATermAppl>> subsumers) {
        Set parents = CollectionUtils.makeSet(subsumers);
        Set supers = CollectionUtils.makeSet();
        Set<ATermAppl> subs = Collections.singleton(ATermUtils.BOTTOM);
        for (TaxonomyNode<ATermAppl> subsumer : subsumers) {
            parents.removeAll(subsumer.getSupers());
        }
        for (TaxonomyNode parent : parents) {
            supers.add(parent.getName());
            parent.removeSub(this.taxonomy.getBottom());
        }
        return this.taxonomy.addNode(Collections.singleton(c), (Collection)supers, subs, false);
    }
}

