/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ConceptInfo;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.el.ELTaxonomyBuilder;
import com.clarkparsia.pellet.el.RoleChainCache;
import com.clarkparsia.pellet.el.RoleRestrictionCache;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifiedELClassifier
extends CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    public static final Logger logger = Logger.getLogger(SimplifiedELClassifier.class.getName());
    public final Timers timers = new Timers();
    private static final boolean PREPROCESS_DOMAINS = false;
    private static final boolean MATERIALIZE_SUPER_PROPERTIES = false;
    private ConceptInfo TOP;
    private ConceptInfo BOTTOM;
    private boolean hasComplexRoles;
    private Queue<QueueElement> primaryQueue;
    private Map<ATermAppl, ConceptInfo> concepts;
    private MultiValueMap<ATermAppl, ConceptInfo> existentials;
    private MultiValueMap<ConceptInfo, ConceptInfo> conjunctions;
    private RoleChainCache roleChains;
    private RoleRestrictionCache roleRestrictions;

    protected void reset() {
        super.reset();
        this.hasComplexRoles = this.kb.getExpressivity().hasTransitivity() || this.kb.getExpressivity().hasComplexSubRoles();
        this.primaryQueue = new LinkedList<QueueElement>();
        this.concepts = CollectionUtils.makeMap();
        this.existentials = new MultiValueMap();
        this.conjunctions = new MultiValueMap();
        this.roleChains = new RoleChainCache(this.kb);
        this.roleRestrictions = new RoleRestrictionCache(this.kb.getRBox());
    }

    public boolean classify() {
        logger.fine("Reset");
        this.reset();
        Timer t = this.timers.startTimer("createConcepts");
        logger.fine("Creating structures");
        this.createConcepts();
        logger.fine("Created structures");
        t.stop();
        int queueSize = this.primaryQueue.size();
        this.monitor.setProgressTitle("Classifiying");
        this.monitor.setProgressLength(queueSize);
        this.monitor.taskStarted();
        logger.fine("Processing queue");
        t = this.timers.startTimer("processQueue");
        this.processQueue();
        t.stop();
        logger.fine("Processed queue");
        if (logger.isLoggable(Level.FINER)) {
            this.print();
        }
        this.monitor.setProgress(queueSize);
        logger.fine("Building hierarchy");
        t = this.timers.startTimer("buildHierarchy");
        this.taxonomy = new ELTaxonomyBuilder().build(this.concepts);
        t.stop();
        logger.fine("Builded hierarchy");
        this.monitor.taskFinished();
        return true;
    }

    private void addSuccessor(ConceptInfo pred, ATermAppl p, ConceptInfo succ) {
        ATermAppl propDomain;
        if (!pred.addSuccessor(p, succ)) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Adding " + pred + " -> " + ATermUtils.toString((ATermAppl)p) + " -> " + succ);
        }
        if (succ == this.BOTTOM) {
            this.addToQueue(pred, this.BOTTOM);
            return;
        }
        for (ConceptInfo supOfSucc : succ.getSuperClasses()) {
            this.addSuccessor(pred, p, supOfSucc);
        }
        if (!this.roleChains.isAnon(p)) {
            Set superRoles = this.kb.getRole((ATerm)p).getSuperRoles();
            for (Role superRole : superRoles) {
                if (!this.existentials.contains((Object)superRole.getName(), (Object)succ)) continue;
                ATermAppl some = ATermUtils.makeSomeValues((ATerm)superRole.getName(), (ATerm)succ.getConcept());
                this.addToQueue(pred, this.concepts.get(some));
            }
        }
        if ((propDomain = this.roleRestrictions.getDomain(p)) != null) {
            this.addToQueue(pred, this.concepts.get(propDomain));
        }
        if (this.hasComplexRoles) {
            for (Map.Entry entry : CollectionUtils.makeList((Collection)pred.getPredecessors().entrySet())) {
                ATermAppl predProp = (ATermAppl)entry.getKey();
                for (ATermAppl supProp : this.roleChains.getAllSuperRoles(predProp, p)) {
                    for (ConceptInfo predOfPred : CollectionUtils.makeList((Collection)((Collection)entry.getValue()))) {
                        this.addSuccessor(predOfPred, supProp, succ);
                    }
                }
            }
            for (Map.Entry entry : CollectionUtils.makeList((Collection)succ.getSuccessors().entrySet())) {
                ATermAppl succProp = (ATermAppl)entry.getKey();
                for (ATermAppl supProp : this.roleChains.getAllSuperRoles(p, succProp)) {
                    for (ConceptInfo succOfSucc : CollectionUtils.makeList((Collection)((Collection)entry.getValue()))) {
                        this.addSuccessor(pred, supProp, succOfSucc);
                    }
                }
            }
        }
    }

    private void addToQueue(ConceptInfo sub, ConceptInfo sup) {
        if (sub.addSuperClass(sup)) {
            this.primaryQueue.add(new QueueElement(sub, sup));
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Queue " + sub + " " + sup);
            }
        }
    }

    private void addSuperClass(ConceptInfo sub, ConceptInfo sup) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Adding " + sub + " < " + sup);
        }
        if (sup == this.BOTTOM) {
            Iterator preds = sub.getPredecessors().flattenedValues();
            while (preds.hasNext()) {
                this.addToQueue((ConceptInfo)preds.next(), sup);
            }
            return;
        }
        for (ConceptInfo supOfSup : sup.getSuperClasses()) {
            if (supOfSup.equals(sup)) continue;
            this.addToQueue(sub, supOfSup);
        }
        ATermAppl c = sup.getConcept();
        if (ATermUtils.isAnd((ATermAppl)c)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.addToQueue(sub, this.concepts.get(conj));
                list = list.getNext();
            }
        } else if (ATermUtils.isSomeValues((ATermAppl)c)) {
            ATermAppl p = (ATermAppl)c.getArgument(0);
            ATermAppl qualification = (ATermAppl)c.getArgument(1);
            this.addSuccessor(sub, p, this.concepts.get(qualification));
        } else assert (ATermUtils.isPrimitive((ATermAppl)c));
        Set referredConjunctions = (Set)this.conjunctions.get((Object)sup);
        if (referredConjunctions != null) {
            for (ConceptInfo conjunction : referredConjunctions) {
                ATermAppl conj;
                ATermList list = (ATermList)conjunction.getConcept().getArgument(0);
                while (!list.isEmpty() && sub.hasSuperClass(this.concepts.get(conj = (ATermAppl)list.getFirst()))) {
                    list = list.getNext();
                }
                if (!list.isEmpty()) continue;
                this.addToQueue(sub, conjunction);
            }
        }
        for (Map.Entry e : sub.getPredecessors().entrySet()) {
            ATermAppl prop = (ATermAppl)e.getKey();
            Role role = this.kb.getRole((ATerm)prop);
            if (role == null) continue;
            Set superRoles = role.getSuperRoles();
            for (Role superRole : superRoles) {
                if (!this.existentials.contains((Object)superRole.getName(), (Object)sup)) continue;
                ATermAppl some = ATermUtils.makeSomeValues((ATerm)superRole.getName(), (ATerm)c);
                for (ConceptInfo pred : (Set)e.getValue()) {
                    this.addToQueue(pred, this.concepts.get(some));
                }
            }
        }
    }

    private ConceptInfo createConcept(ATermAppl c) {
        ConceptInfo concept = this.concepts.get(c);
        if (concept == null) {
            concept = new ConceptInfo(c, this.hasComplexRoles, false);
            if (ATermUtils.isAnd((ATermAppl)c)) {
                ATermList list = (ATermList)c.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl conj = (ATermAppl)list.getFirst();
                    ConceptInfo conjConcept = this.createConcept(conj);
                    this.addToQueue(concept, conjConcept);
                    this.conjunctions.add((Object)conjConcept, (Object)concept);
                    list = list.getNext();
                }
            } else if (ATermUtils.isSomeValues((ATermAppl)c)) {
                ATermAppl newQ;
                ATermAppl p = (ATermAppl)c.getArgument(0);
                ATermAppl q = (ATermAppl)c.getArgument(1);
                if (ATermUtils.isInv((ATermAppl)p)) {
                    throw new UnsupportedOperationException("Anonmyous inverse found in restriction: " + ATermUtils.toString((ATermAppl)c));
                }
                ATermAppl range = this.roleRestrictions.getRange(p);
                if (range != null && !(newQ = ATermUtils.makeSimplifiedAnd(Arrays.asList(range, q))).equals(q)) {
                    ATermAppl newC = ATermUtils.makeSomeValues((ATerm)p, (ATerm)newQ);
                    concept = this.createConcept(newC);
                    this.concepts.put(c, concept);
                    c = newC;
                }
                ConceptInfo succ = this.createConcept(q);
                this.existentials.add((Object)p, (Object)succ);
                this.addToQueue(concept, concept);
            }
            this.concepts.put(c, concept);
            concept.addSuperClass(concept);
            if (this.TOP != null) {
                this.addToQueue(concept, this.TOP);
            }
        }
        return concept;
    }

    private void createConceptsFromAxiom(ATermAppl sub, ATermAppl sup) {
        this.addToQueue(this.createConcept(sub), this.createConcept(sup));
    }

    private void createDisjointAxiom(ATermAppl c1, ATermAppl c2) {
        this.createConcept(c1);
        this.createConcept(c2);
        ATermAppl and = ATermUtils.makeSimplifiedAnd(Arrays.asList(c1, c2));
        this.createConceptsFromAxiom(and, ATermUtils.BOTTOM);
    }

    private void processAxiom(ATermAppl axiom) {
        AFun fun = axiom.getAFun();
        if (fun.equals(ATermUtils.DISJOINTSFUN)) {
            ATermList concepts = (ATermList)axiom.getArgument(0);
            int n = concepts.getLength();
            ATermAppl[] simplified = new ATermAppl[n];
            int i = 0;
            while (!concepts.isEmpty()) {
                simplified[i] = ELSyntaxUtils.simplify((ATermAppl)concepts.getFirst());
                concepts = concepts.getNext();
                ++i;
            }
            for (i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    this.createDisjointAxiom(simplified[i], simplified[j]);
                }
            }
        } else {
            ATermAppl sub = (ATermAppl)axiom.getArgument(0);
            ATermAppl sup = (ATermAppl)axiom.getArgument(1);
            sub = ELSyntaxUtils.simplify(sub);
            sup = ELSyntaxUtils.simplify(sup);
            if (fun.equals(ATermUtils.SUBFUN)) {
                this.createConceptsFromAxiom(sub, sup);
            } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
                this.createConceptsFromAxiom(sub, sup);
                this.createConceptsFromAxiom(sup, sub);
            } else if (fun.equals(ATermUtils.DISJOINTFUN)) {
                this.createDisjointAxiom(sub, sup);
            } else {
                throw new IllegalArgumentException("Axiom " + axiom + " is not EL.");
            }
        }
    }

    private void processAxioms() {
        Collection assertedAxioms = this.kb.getTBox().getAssertedAxioms();
        for (ATermAppl assertedAxiom : assertedAxioms) {
            this.processAxiom(assertedAxiom);
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            ATermAppl range;
            if (!role.isReflexive() || (range = this.roleRestrictions.getRange(role.getName())) == null) continue;
            this.createConceptsFromAxiom(ATermUtils.TOP, range);
        }
    }

    private void createConcepts() {
        this.TOP = this.createConcept(ATermUtils.TOP);
        this.BOTTOM = this.createConcept(ATermUtils.BOTTOM);
        for (ATermAppl c : this.kb.getClasses()) {
            this.createConcept(c);
        }
        this.processAxioms();
        logger.fine("Process domain and ranges");
        for (ATermAppl c : this.roleRestrictions.getRanges().values()) {
            this.createConcept(c);
        }
        for (ATermAppl c : this.roleRestrictions.getDomains().values()) {
            this.createConcept(c);
        }
    }

    public void print() {
        for (ATermAppl c : this.concepts.keySet()) {
            log.finer(c + " " + this.concepts.get(c).getSuperClasses());
        }
        log.finer("");
        this.roleChains.print();
    }

    private void processQueue() {
        int startingSize = this.primaryQueue.size();
        while (!this.primaryQueue.isEmpty()) {
            int processed = startingSize - this.primaryQueue.size();
            if (this.monitor.getProgress() < processed) {
                this.monitor.setProgress(processed);
            }
            QueueElement qe = this.primaryQueue.remove();
            this.addSuperClass(qe.sub, qe.sup);
        }
    }

    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        return Collections.emptyMap();
    }

    public Taxonomy<ATermAppl> getToldTaxonomy() {
        return new Taxonomy((Collection)this.kb.getTBox().getClasses(), (Object)TermFactory.TOP, (Object)TermFactory.BOTTOM);
    }

    private static class QueueElement {
        private final ConceptInfo sub;
        private final ConceptInfo sup;

        public QueueElement(ConceptInfo sub, ConceptInfo sup) {
            this.sub = sub;
            this.sup = sup;
        }
    }
}

