/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.OntologyDiff;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.owlapiv3.OWLClassTreePrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletClassify
extends PelletCmdApp {
    private static final int ENCODING_RADIX = 36;
    private static final String FILE_NAME_PATTERN = "persisted-state-%s.zip";
    private File saveDirectory = new File(".");
    private boolean currentStateSaved = false;

    public String getAppCmd() {
        return "pellet classify " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletClassify: Classify the ontology and display the hierarchy";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        PelletCmdOption option = new PelletCmdOption("persist");
        option.setShortOption("p");
        option.setDescription("Enable persistence of classification results. The classifier will save its internal state in a file, and will reuse it the next time this ontology is loaded, therefore saving classification time. This option can only be used with OWLAPIv3 loader.");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        options.add(this.getLoaderOption());
        options.add(this.getIgnoreImportsOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        if (this.options.getOption("persist").getValueAsBoolean()) {
            this.runIncrementalClassify();
        } else {
            this.runClassicClassify();
        }
    }

    private void runClassicClassify() {
        KnowledgeBase kb = this.getKB();
        this.startTask("consistency check");
        boolean isConsistent = kb.isConsistent();
        this.finishTask("consistency check");
        if (!isConsistent) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        this.startTask("classification");
        kb.classify();
        this.finishTask("classification");
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(kb.getTaxonomy());
    }

    private void runIncrementalClassify() {
        String loaderName = this.options.getOption("loader").getValueAsString();
        if (!"OWLAPIv3".equals(loaderName)) {
            logger.log(Level.WARNING, "Ignoring -l " + loaderName + " option. When using --persist the only allowed loader is OWLAPIv3");
        }
        OWLAPILoader loader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        loader.parse(this.getInputFiles());
        OWLOntology ontology = loader.getOntology();
        IncrementalClassifier incrementalClassifier = this.createIncrementalClassifier(ontology);
        if (!incrementalClassifier.isClassified()) {
            this.startTask("consistency check");
            boolean isConsistent = incrementalClassifier.isConsistent();
            this.finishTask("consistency check");
            if (!isConsistent) {
                throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
            }
            this.startTask("classification");
            incrementalClassifier.classify();
            this.finishTask("classification");
        }
        OWLClassTreePrinter printer = new OWLClassTreePrinter();
        printer.print(incrementalClassifier.getTaxonomy());
        if (!this.currentStateSaved) {
            this.persistIncrementalClassifier(incrementalClassifier, ontology);
        }
    }

    private IncrementalClassifier createIncrementalClassifier(OWLOntology ontology) {
        File saveFile = this.determineSaveFile(ontology);
        IncrementalClassifier result = null;
        if (saveFile.exists()) {
            result = this.loadIncrementalClassifier(ontology, saveFile);
        }
        if (result == null) {
            result = new IncrementalClassifier(ontology);
        }
        result.getReasoner().getKB().setTaxonomyBuilderProgressMonitor(PelletOptions.USE_CLASSIFICATION_MONITOR.create());
        return result;
    }

    private void persistIncrementalClassifier(IncrementalClassifier incrementalClassifier, OWLOntology ontology) {
        File saveFile = this.determineSaveFile(ontology);
        try {
            this.verbose("Saving the state of the classifier to " + saveFile);
            FileOutputStream outputStream = new FileOutputStream(saveFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)incrementalClassifier, (OutputStream)outputStream);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to persist the current classifier state: " + e.toString());
        }
    }

    private IncrementalClassifier loadIncrementalClassifier(OWLOntology ontology, File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            this.verbose("Reading persisted classifier state from " + file);
            IncrementalClassifier result = IncrementalClassifierPersistence.load((InputStream)inputStream, (OWLOntology)ontology);
            OntologyDiff ontologyDiff = OntologyDiff.diffAxioms((Collection)result.getAxioms(), (Collection)ontology.getAxioms());
            if (ontologyDiff.getDiffCount() > 0) {
                this.verbose("There were changes to the underlying ontology since the classifier was persisted. Incrementally updating the classifier");
                result.ontologiesChanged(new LinkedList(ontologyDiff.getChanges(ontology)));
            } else {
                this.currentStateSaved = true;
            }
            return result;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to read the persisted information from a file. Pellet will perform full classification: " + e);
            return null;
        }
        catch (OWLException e) {
            logger.log(Level.WARNING, "Unable to incrementally update the classifier. Pellet will perform full classification: " + (Object)((Object)e));
            return null;
        }
    }

    private File determineSaveFile(OWLOntology ontology) {
        String fileName = String.format(FILE_NAME_PATTERN, this.hashOntologyIRI(ontology));
        return new File(this.saveDirectory, fileName);
    }

    private String hashOntologyIRI(OWLOntology ontology) {
        byte[] uriBytes = ontology.getOntologyID().getOntologyIRI().toString().getBytes();
        MessageDigest MD5 = null;
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PelletCmdException("MD5 digest algorithm is not available.");
        }
        byte[] hashBytes = MD5.digest(uriBytes);
        BigInteger bi = new BigInteger(1, hashBytes);
        return bi.toString(36);
    }
}

