/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import org.mindswap.pellet.KnowledgeBase;
import pellet.PelletCmdApp;
import pellet.PelletCmdOptions;

public class PelletConsistency
extends PelletCmdApp {
    public String getAppCmd() {
        return "pellet consistency " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletConsistency: Check the consistency of an ontology";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getLoaderOption());
        options.add(this.getIgnoreImportsOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        KnowledgeBase kb = this.getKB();
        this.startTask("consistency check");
        boolean isConsistent = kb.isConsistent();
        this.finishTask("consistency check");
        if (isConsistent) {
            this.output("Consistent: Yes");
        } else {
            this.output("Consistent: No");
            this.output("Reason: " + kb.getExplanation());
        }
    }
}

