/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxObjectRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.TextBlockWriter;
import com.clarkparsia.pellet.owlapiv3.EntailmentChecker;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletEntailment
extends PelletCmdApp {
    private String entailmentFile;
    private boolean findAll;

    public String getAppId() {
        return "PelletEntailment: Check if all axioms are entailed by the ontology";
    }

    public String getAppCmd() {
        return "pellet entail " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getIgnoreImportsOption());
        PelletCmdOption option = new PelletCmdOption("entailment-file");
        option.setShortOption("e");
        option.setType("<file URI>");
        option.setDescription("Entailment ontology URI");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("all");
        option.setShortOption("a");
        option.setDefaultValue(false);
        option.setDescription("Show all non-entailments");
        option.setDefaultValue(this.findAll);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        return options;
    }

    public void run() {
        this.entailmentFile = this.options.getOption("entailment-file").getValueAsString();
        this.findAll = this.options.getOption("all").getValueAsBoolean();
        OWLAPILoader loader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        this.getKB();
        PelletReasoner reasoner = loader.getReasoner();
        OWLOntology entailmentOntology = null;
        try {
            this.verbose("Loading entailment file: ");
            this.verbose(this.entailmentFile);
            IRI entailmentFileURI = IRI.create((String)FileUtils.toURI((String)this.entailmentFile));
            entailmentOntology = loader.getManager().loadOntology(entailmentFileURI);
        }
        catch (Exception e) {
            throw new PelletCmdException(e);
        }
        EntailmentChecker checker = new EntailmentChecker(reasoner);
        Set axioms = entailmentOntology.getLogicalAxioms();
        this.verbose("Check entailments for (" + axioms.size() + ") axioms");
        this.startTask("Checking");
        Set nonEntailments = checker.findNonEntailments(axioms, this.findAll);
        this.finishTask("Checking");
        if (nonEntailments.isEmpty()) {
            this.output("All axioms are entailed.");
        } else {
            this.output("Non-entailments (" + nonEntailments.size() + "): ");
            int index = 1;
            TextBlockWriter writer = new TextBlockWriter((Writer)new PrintWriter(System.out));
            ManchesterSyntaxObjectRenderer renderer = new ManchesterSyntaxObjectRenderer((BlockWriter)writer);
            writer.println();
            for (OWLAxiom axiom : nonEntailments) {
                writer.print(index++);
                writer.print(")");
                writer.printSpace();
                writer.startBlock();
                axiom.accept((OWLObjectVisitor)renderer);
                writer.endBlock();
                writer.println();
            }
            writer.flush();
        }
    }
}

