/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.GlassBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxExplanationRenderer;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletExplain
extends PelletCmdApp {
    private SatisfiabilityConverter converter;
    private int errorExpCount = 0;
    private OWLAPILoader loader;
    private int maxExplanations = 1;
    private boolean useBlackBox = false;
    private ProgressMonitor monitor;
    private int multiAxiomExpCount = 0;
    private int multipleExpCount = 0;
    private PelletReasoner reasoner;
    private OWLEntity name1;
    private OWLEntity name2;
    private OWLObject name3;

    public PelletExplain() {
        GlassBoxExplanation.setup();
    }

    @Override
    public String getAppId() {
        return "PelletExplain: Explains one or more inferences in a given ontology including ontology inconsistency";
    }

    @Override
    public String getAppCmd() {
        return "pellet explain " + this.getMandatoryOptions() + "[options] <file URI>...\n\n" + "The options --unsat, --all-unsat, --inconsistent, --subclass, \n" + "--hierarchy, and --instance are mutually exclusive. By default \n " + "--inconsistent option is assumed. In the following descriptions \n" + "C, D, and i can be URIs or local names.";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getIgnoreImportsOption());
        PelletCmdOption option = new PelletCmdOption("unsat");
        option.setType("C");
        option.setDescription("Explain why the given class is unsatisfiable");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("all-unsat");
        option.setDescription("Explain all unsatisfiable classes");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("inconsistent");
        option.setDescription("Explain why the ontology is inconsistent");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("hierarchy");
        option.setDescription("Print all explanations for the class hierarchy");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("subclass");
        option.setDescription("Explain why C is a subclass of D");
        option.setType("C,D");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("instance");
        option.setDescription("Explain why i is an instance of C");
        option.setType("i,C");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("property-value");
        option.setDescription("Explain why s has value o for property p");
        option.setType("s,p,o");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("method");
        option.setShortOption("m");
        option.setType("glass | black");
        option.setDescription("Method that will be used to generate explanations");
        option.setDefaultValue("glass");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("max");
        option.setShortOption("x");
        option.setType("positive integer");
        option.setDescription("Maximum number of generated explanations for each inference");
        option.setDefaultValue(1);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = options.getOption("verbose");
        option.setDescription("Print detailed exceptions and messages about the progress");
        return options;
    }

    @Override
    public void parseArgs(String[] args) {
        super.parseArgs(args);
        this.maxExplanations = this.options.getOption("max").getValueAsNonNegativeInteger();
        this.loader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        this.getKB();
        this.converter = new SatisfiabilityConverter(this.loader.getManager().getOWLDataFactory());
        this.reasoner = this.loader.getReasoner();
        this.loadMethod();
        this.loadNames();
    }

    @Override
    public void run() {
        try {
            if (this.name1 == null) {
                this.verbose("Explain all the subclass relations in the ontology");
                this.explainClassHierarchy();
            } else if (this.name2 == null) {
                if (((OWLClassExpression)this.name1).isOWLNothing()) {
                    this.verbose("Explain all the unsatisfiable classes");
                    this.explainUnsatisfiableClasses();
                } else {
                    this.verbose("Explain unsatisfiability of " + this.name1);
                    this.explainUnsatisfiableClass((OWLClass)this.name1);
                }
            } else if (this.name3 != null) {
                this.verbose("Explain property assertion " + this.name1 + " and " + this.name2 + " and " + this.name3);
                this.explainPropertyValue((OWLIndividual)this.name1, (OWLProperty)this.name2, this.name3);
            } else if (this.name1.isOWLClass() && this.name2.isOWLClass()) {
                this.verbose("Explain subclass relation between " + this.name1 + " and " + this.name2);
                this.explainSubClass((OWLClass)this.name1, (OWLClass)this.name2);
            } else if (this.name1.isOWLNamedIndividual() && this.name2.isOWLClass()) {
                this.verbose("Explain instance relation between " + this.name1 + " and " + this.name2);
                this.explainInstance((OWLIndividual)this.name1, (OWLClass)this.name2);
            }
            this.printStatistics();
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    private void explainAxiom(OWLAxiom axiom) throws OWLException {
        int expSize;
        HSTExplanationGenerator expGen = new HSTExplanationGenerator(this.getSingleExplanationGenerator());
        RendererExplanationProgressMonitor rendererMonitor = new RendererExplanationProgressMonitor(axiom);
        expGen.setProgressMonitor((ExplanationProgressMonitor)rendererMonitor);
        OWLClassExpression unsatClass = this.converter.convert(axiom);
        Timer timer = this.timers.startTimer("explain");
        Set explanations = expGen.getExplanations(unsatClass, this.maxExplanations);
        timer.stop();
        if (explanations.isEmpty()) {
            rendererMonitor.foundNoExplanations();
        }
        if (timer.getCount() % 10L == 0L) {
            // empty if block
        }
        if ((expSize = explanations.size()) == 0) {
            ++this.errorExpCount;
        } else if (expSize == 1) {
            if (((Set)explanations.iterator().next()).size() > 1) {
                ++this.multiAxiomExpCount;
            }
        } else {
            ++this.multipleExpCount;
        }
    }

    public void explainClassHierarchy() throws OWLException {
        HashSet<OWLClass> visited = new HashSet<OWLClass>();
        this.reasoner.flush();
        this.startTask("Classification");
        this.reasoner.getKB().classify();
        this.finishTask("Classification");
        this.startTask("Realization");
        this.reasoner.getKB().realize();
        this.finishTask("Realization");
        this.monitor = new ConsoleProgressMonitor();
        this.monitor.setProgressTitle("Explaining");
        this.monitor.setProgressLength(this.reasoner.getRootOntology().getClassesInSignature().size());
        this.monitor.taskStarted();
        Node bottoms = this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing);
        this.explainClassHierarchy(OWL.Nothing, (Node<OWLClass>)bottoms, visited);
        Node tops = this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.Thing);
        this.explainClassHierarchy(OWL.Thing, (Node<OWLClass>)tops, visited);
        this.monitor.taskFinished();
    }

    public void explainEquivalentClass(OWLClass c1, OWLClass c2) throws OWLException {
        if (c1.equals(c2)) {
            return;
        }
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)c1, (OWLClassExpression)c2);
        this.explainAxiom((OWLAxiom)axiom);
    }

    public void explainInstance(OWLIndividual ind, OWLClass c) throws OWLException {
        if (c.isOWLThing()) {
            return;
        }
        OWLClassAssertionAxiom axiom = OWL.classAssertion((OWLIndividual)ind, (OWLClassExpression)c);
        this.explainAxiom((OWLAxiom)axiom);
    }

    public void explainPropertyValue(OWLIndividual s, OWLProperty p, OWLObject o) throws OWLException {
        if (p.isOWLObjectProperty()) {
            this.explainAxiom((OWLAxiom)OWL.propertyAssertion((OWLIndividual)s, (OWLObjectPropertyExpression)((OWLObjectProperty)p), (OWLIndividual)((OWLIndividual)o)));
        } else {
            this.explainAxiom((OWLAxiom)OWL.propertyAssertion((OWLIndividual)s, (OWLDataPropertyExpression)((OWLDataProperty)p), (OWLLiteral)((OWLLiteral)o)));
        }
    }

    public void explainSubClass(OWLClass sub, OWLClass sup) throws OWLException {
        if (sub.equals(sup)) {
            return;
        }
        if (sub.isOWLNothing()) {
            return;
        }
        if (sup.isOWLThing()) {
            return;
        }
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)sub, (OWLClassExpression)sup);
        this.explainAxiom((OWLAxiom)axiom);
    }

    public void explainUnsatisfiableClasses() throws OWLException {
        for (OWLClass cls : this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing)) {
            if (cls.isOWLNothing()) continue;
            this.explainUnsatisfiableClass(cls);
        }
    }

    public void explainUnsatisfiableClass(OWLClass cls) throws OWLException {
        this.explainSubClass(cls, OWL.Nothing);
    }

    private void explainClassHierarchy(OWLClass cls, Node<OWLClass> eqClasses, Set<OWLClass> visited) throws OWLException {
        if (visited.contains(cls)) {
            return;
        }
        visited.add(cls);
        visited.addAll(eqClasses.getEntities());
        for (OWLClass eqClass : eqClasses) {
            this.monitor.incrementProgress();
            this.explainEquivalentClass(cls, eqClass);
        }
        for (OWLNamedIndividual ind : this.reasoner.getInstances((OWLClassExpression)cls, true).getFlattened()) {
            this.explainInstance((OWLIndividual)ind, cls);
        }
        NodeSet subClasses = this.reasoner.getSubClasses((OWLClassExpression)cls, true);
        HashMap<OWLClass, Node> subClassEqs = new HashMap<OWLClass, Node>();
        for (Node equivalenceSet : subClasses) {
            if (equivalenceSet.isBottomNode()) continue;
            OWLClass subClass = (OWLClass)equivalenceSet.getRepresentativeElement();
            subClassEqs.put(subClass, equivalenceSet);
            this.explainSubClass(subClass, cls);
        }
        for (Map.Entry entry : subClassEqs.entrySet()) {
            this.explainClassHierarchy((OWLClass)entry.getKey(), (Node<OWLClass>)((Node)entry.getValue()), visited);
        }
    }

    private TransactionAwareSingleExpGen getSingleExplanationGenerator() {
        if (this.useBlackBox) {
            if (this.options.getOption("inconsistent") != null) {
                if (!this.options.getOption("inconsistent").getValueAsBoolean()) {
                    return new BlackBoxExplanation(this.reasoner.getRootOntology(), (OWLReasonerFactory)PelletReasonerFactory.getInstance(), (OWLReasoner)this.reasoner);
                }
                this.output("WARNING: black method cannot be used to explain inconsistency. Switching to glass.");
                return new GlassBoxExplanation(this.reasoner);
            }
            return new BlackBoxExplanation(this.reasoner.getRootOntology(), (OWLReasonerFactory)PelletReasonerFactory.getInstance(), (OWLReasoner)this.reasoner);
        }
        return new GlassBoxExplanation(this.reasoner);
    }

    private void loadMethod() {
        String method = this.options.getOption("method").getValueAsString();
        if (method.equalsIgnoreCase("black")) {
            this.useBlackBox = true;
        } else if (method.equalsIgnoreCase("glass")) {
            this.useBlackBox = false;
        } else {
            throw new PelletCmdException("Unrecognized method: " + method);
        }
    }

    private void loadNames() {
        String optionValue;
        String instance;
        String subclass;
        String unsatisfiable;
        this.name2 = null;
        this.name1 = null;
        this.name3 = null;
        PelletCmdOption option = this.options.getOption("hierarchy");
        if (option != null && option.getValueAsBoolean()) {
            return;
        }
        option = this.options.getOption("all-unsat");
        if (option != null && option.getValueAsBoolean()) {
            this.name1 = OWL.Nothing;
            return;
        }
        option = this.options.getOption("inconsistent");
        if (option != null && option.getValueAsBoolean()) {
            if (this.useBlackBox) {
                throw new PelletCmdException("Black box method cannot be used to explain ontology inconsistency");
            }
            this.name1 = OWL.Thing;
            return;
        }
        option = this.options.getOption("unsat");
        if (option != null && (unsatisfiable = option.getValueAsString()) != null) {
            this.name1 = OntologyUtils.findEntity((String)unsatisfiable, (Set)this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + unsatisfiable);
            }
            if (!this.name1.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + unsatisfiable);
            }
            if (this.name1.isTopEntity() && this.useBlackBox) {
                throw new PelletCmdException("Black box method cannot be used to explain unsatisfiability of owl:Thing");
            }
            return;
        }
        option = this.options.getOption("subclass");
        if (option != null && (subclass = option.getValueAsString()) != null) {
            String[] names = subclass.split(",");
            if (names.length != 2) {
                throw new PelletCmdException("Invalid format for subclass option: " + subclass);
            }
            this.name1 = OntologyUtils.findEntity((String)names[0], (Set)this.loader.getAllOntologies());
            this.name2 = OntologyUtils.findEntity((String)names[1], (Set)this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + names[0]);
            }
            if (!this.name1.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + names[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + names[1]);
            }
            if (!this.name2.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + names[1]);
            }
            return;
        }
        option = this.options.getOption("instance");
        if (option != null && (instance = option.getValueAsString()) != null) {
            String[] names = instance.split(",");
            if (names.length != 2) {
                throw new PelletCmdException("Invalid format for instance option: " + instance);
            }
            this.name1 = OntologyUtils.findEntity((String)names[0], (Set)this.loader.getAllOntologies());
            this.name2 = OntologyUtils.findEntity((String)names[1], (Set)this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + names[0]);
            }
            if (!this.name1.isOWLNamedIndividual()) {
                throw new PelletCmdException("Not a defined individual: " + names[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + names[1]);
            }
            if (!this.name2.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + names[1]);
            }
            return;
        }
        option = this.options.getOption("property-value");
        if (option != null && (optionValue = option.getValueAsString()) != null) {
            String[] names = optionValue.split(",");
            if (names.length != 3) {
                throw new PelletCmdException("Invalid format for property-value option: " + optionValue);
            }
            this.name1 = OntologyUtils.findEntity((String)names[0], (Set)this.loader.getAllOntologies());
            this.name2 = OntologyUtils.findEntity((String)names[1], (Set)this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + names[0]);
            }
            if (!this.name1.isOWLNamedIndividual()) {
                throw new PelletCmdException("Not an individual: " + names[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + names[1]);
            }
            if (!this.name2.isOWLObjectProperty() && !this.name2.isOWLDataProperty()) {
                throw new PelletCmdException("Not a defined property: " + names[1]);
            }
            if (this.name2.isOWLObjectProperty()) {
                this.name3 = OntologyUtils.findEntity((String)names[2], (Set)this.loader.getAllOntologies());
                if (this.name3 == null) {
                    throw new PelletCmdException("Undefined entity: " + names[2]);
                }
                if (!(this.name3 instanceof OWLIndividual)) {
                    throw new PelletCmdException("Not a defined individual: " + names[2]);
                }
            } else {
                ManchesterOWLSyntaxEditorParser parser = new ManchesterOWLSyntaxEditorParser(this.loader.getManager().getOWLDataFactory(), names[2]);
                try {
                    this.name3 = parser.parseConstant();
                }
                catch (ParserException e) {
                    throw new PelletCmdException("Not a valid literal: " + names[2]);
                }
            }
            return;
        }
        this.name1 = OWL.Thing;
        if (this.useBlackBox) {
            throw new PelletCmdException("Black box method cannot be used to explain ontology inconsistency");
        }
    }

    private void printStatistics() throws OWLException {
        if (!this.verbose) {
            return;
        }
        Timer timer = this.timers.getTimer("explain");
        if (timer != null) {
            this.verbose("Subclass relations   : " + timer.getCount());
            this.verbose("Multiple explanations: " + this.multipleExpCount);
            this.verbose("Single explanation     ");
            this.verbose(" with multiple axioms: " + this.multiAxiomExpCount);
            this.verbose("Error explaining     : " + this.errorExpCount);
            this.verbose("Average time         : " + timer.getAverage() + "ms");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RendererExplanationProgressMonitor
    implements ExplanationProgressMonitor {
        private ExplanationRenderer rend = new ManchesterSyntaxExplanationRenderer();
        private OWLAxiom axiom;
        private Set<Set<OWLAxiom>> setExplanations;
        private PrintWriter pw;

        private RendererExplanationProgressMonitor(OWLAxiom axiom) {
            this.axiom = axiom;
            this.pw = new PrintWriter(System.out);
            this.setExplanations = new HashSet<Set<OWLAxiom>>();
            try {
                this.rend.startRendering((Writer)this.pw);
            }
            catch (OWLException e) {
                System.err.println("Error rendering explanation: " + (Object)((Object)e));
            }
            catch (IOException e) {
                System.err.println("Error rendering explanation: " + e);
            }
        }

        public void foundExplanation(Set<OWLAxiom> axioms) {
            if (!this.setExplanations.contains(axioms)) {
                this.setExplanations.add(axioms);
                this.pw.flush();
                try {
                    this.rend.render(this.axiom, Collections.singleton(axioms));
                }
                catch (IOException e) {
                    System.err.println("Error rendering explanation: " + e);
                }
                catch (OWLException e) {
                    System.err.println("Error rendering explanation: " + (Object)((Object)e));
                }
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public void foundAllExplanations() {
            try {
                this.rend.endRendering();
            }
            catch (OWLException e) {
                System.err.println("Error rendering explanation: " + (Object)((Object)e));
            }
            catch (IOException e) {
                System.err.println("Error rendering explanation: " + e);
            }
        }

        public void foundNoExplanations() {
            try {
                this.rend.render(this.axiom, Collections.emptySet());
                this.rend.endRendering();
            }
            catch (OWLException e) {
                System.err.println("Error rendering explanation: " + (Object)((Object)e));
            }
            catch (IOException e) {
                System.err.println("Error rendering explanation: " + e);
            }
        }
    }
}

