/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.file.MetaFile;
import java.io.File;
import java.io.IOException;
import org.apache.jena.atlas.lib.Lib;

public class Location {
    static String pathSeparator = File.separator;
    private String pathname;
    private MetaFile metafile = null;
    private boolean isMem = false;
    private boolean isMemUnique = false;
    static int memoryCount = 0;

    public static Location mem() {
        return Location.mem(null);
    }

    public static Location mem(String name) {
        Location loc = new Location();
        Location.memInit(loc, name);
        return loc;
    }

    private Location() {
    }

    private static void memInit(Location location, String name) {
        location.pathname = "--mem--";
        if (name != null) {
            name = name.replace('\\', '/');
            location.pathname = location.pathname + '/' + name;
        } else {
            location.isMemUnique = true;
        }
        if (!location.pathname.endsWith(pathSeparator)) {
            location.pathname = location.pathname + '/';
        }
        location.isMem = true;
        location.metafile = new MetaFile("--mem--", "--mem--");
    }

    public Location(String rootname) {
        if (rootname.equals("--mem--")) {
            Location.memInit(this, null);
            return;
        }
        this.ensure(rootname);
        this.pathname = this.fixupName(rootname);
        String metafileName = this.getPath("this", "info");
        this.metafile = new MetaFile("Location: " + rootname, metafileName);
    }

    private String fixupName(String fsName) {
        if (this.isMem()) {
            return fsName;
        }
        File file = new File(fsName);
        try {
            fsName = file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new FileException("Failed to get canoncial path: " + file.getAbsolutePath(), ex);
        }
        if (!fsName.endsWith(File.separator) && !fsName.endsWith(pathSeparator)) {
            fsName = fsName + pathSeparator;
        }
        return fsName;
    }

    public String getDirectoryPath() {
        return this.pathname;
    }

    public MetaFile getMetaFile() {
        return this.metafile;
    }

    public boolean isMem() {
        return this.isMem;
    }

    public boolean isMemUnique() {
        return this.isMemUnique;
    }

    public Location getSubLocation(String dirname) {
        String newName = this.pathname + dirname;
        this.ensure(newName);
        return new Location(newName);
    }

    private void ensure(String dirname) {
        if (this.isMem()) {
            return;
        }
        File file = new File(dirname);
        if (file.exists() && !file.isDirectory()) {
            throw new FileException("Existing file: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String getSubDirectory(String dirname) {
        return this.getSubLocation(dirname).getDirectoryPath();
    }

    public String absolute(String filename, String extension) {
        return extension == null ? this.absolute(filename) : this.absolute(filename + "." + extension);
    }

    public String absolute(String filename) {
        File f = new File(filename);
        if (!f.isAbsolute()) {
            filename = this.pathname + filename;
        }
        return filename;
    }

    public boolean exists() {
        File f = new File(this.getDirectoryPath());
        return f.exists() && f.isDirectory() && f.canRead();
    }

    public boolean exists(String filename) {
        return this.exists(filename, null);
    }

    public boolean exists(String filename, String ext) {
        String fn = this.getPath(filename, ext);
        File f = new File(fn);
        return f.exists();
    }

    public String getPath(String filename) {
        return this.getPath(filename, null);
    }

    public String getPath(String filename, String ext) {
        this.check(filename, ext);
        if (ext == null) {
            return this.pathname + filename;
        }
        return this.pathname + filename + "." + ext;
    }

    private void check(String filename, String ext) {
        if (filename == null) {
            throw new FileException("Location: null filename");
        }
        if (filename.contains("/") || filename.contains("\\")) {
            throw new FileException("Illegal file component name: " + filename);
        }
        if (filename.contains(".") && ext != null) {
            throw new FileException("Filename has an extension: " + filename);
        }
        if (ext != null && ext.contains(".")) {
            throw new FileException("Extension has an extension: " + filename);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = this.isMem ? 1 : 2;
        result = 31 * result + (this.pathname == null ? 0 : this.pathname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.isMem && !other.isMem) {
            return false;
        }
        if (!this.isMem && other.isMem) {
            return false;
        }
        if (this.isMemUnique) {
            return false;
        }
        return Lib.equal((Object)this.pathname, (Object)other.pathname);
    }

    public String toString() {
        return "location:" + this.pathname;
    }
}

