/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.out.NodeFmtLib;

public class NodecLib {
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};

    public static String encode(Node node) {
        return NodecLib.encode(node, null);
    }

    public static String encode(Node node, PrefixMapping pmap) {
        String x;
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        if (node.isURI() && (x = StrUtils.encodeHex((String)node.getURI(), (char)'_', (char[])invalidIRIChars)) != node.getURI()) {
            node = NodeFactory.createURI((String)x);
        }
        return NodeFmtLib.str((Node)node);
    }

    public static Node decode(String s) {
        return NodecLib.decode(s, null);
    }

    public static Node decode(String s, PrefixMapping pmap) {
        if (s.startsWith("_:")) {
            s = s.substring(2);
            return NodeFactory.createAnon((AnonId)new AnonId(s));
        }
        if (s.startsWith("<")) {
            s = s.substring(1, s.length() - 1);
            s = StrUtils.decodeHex((String)s, (char)'_');
            return NodeFactory.createURI((String)s);
        }
        try {
            Node n = SSE.parseNode((String)s, (PrefixMapping)pmap);
            return n;
        }
        catch (SSEParseException ex) {
            Log.fatal(NodeLib.class, (String)("decode: Failed to parse: " + s));
            throw ex;
        }
    }
}

