/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.graph.BulkUpdateHandlerTDB;
import com.hp.hpl.jena.tdb.graph.TransactionHandlerTDB;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.riot.other.GLib;

public class GraphTDB
extends GraphView
implements Closeable,
Sync {
    private final BulkUpdateHandler bulkUpdateHandler = new BulkUpdateHandlerTDB(this);
    private final TransactionHandler transactionHandler = new TransactionHandlerTDB(this);
    private final DatasetGraphTDB dataset;
    private static Transform<Tuple<NodeId>, Tuple<NodeId>> project4TupleTo3Tuple = new Transform<Tuple<NodeId>, Tuple<NodeId>>(){

        public Tuple<NodeId> convert(Tuple<NodeId> item) {
            if (item.size() != 4) {
                throw new TDBException("Expected a Tuple of 4, got: " + item);
            }
            return Tuple.createTuple((Object[])new NodeId[]{(NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3)});
        }
    };

    public GraphTDB(DatasetGraphTDB dataset, Node graphName) {
        super((DatasetGraph)dataset, graphName);
        this.dataset = dataset;
    }

    public DatasetGraphTDB getDSG() {
        return this.dataset;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.getDSG().chooseNodeTupleTable(this.getGraphName());
    }

    @Deprecated
    public static NodeTupleTable chooseNodeTupleTable(DatasetGraphTDB dsg, Node graphNode) {
        return dsg.chooseNodeTupleTable(graphNode);
    }

    protected PrefixMapping createPrefixMapping() {
        if (this.isDefaultGraph()) {
            return this.getDSG().getPrefixes().getPrefixMapping();
        }
        if (this.isUnionGraph()) {
            return this.getDSG().getPrefixes().getPrefixMapping();
        }
        return this.getDSG().getPrefixes().getPrefixMapping(this.getGraphName().getURI());
    }

    public final void performAdd(Triple triple) {
        this.startUpdate();
        super.performAdd(triple);
        this.finishUpdate();
    }

    public final void performDelete(Triple triple) {
        this.startUpdate();
        super.performDelete(triple);
        this.finishUpdate();
    }

    public final void sync() {
        this.dataset.sync();
    }

    public final void close() {
        this.sync();
        super.close();
    }

    protected static ExtendedIterator<Triple> graphBaseFindDft(DatasetGraphTDB dataset, TripleMatch m) {
        Iterator iterQuads = dataset.find(Quad.defaultGraphIRI, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iterQuads == null) {
            return NullIterator.instance();
        }
        ProjectQuadsToTriples iterTriples = new ProjectQuadsToTriples(Quad.defaultGraphIRI, iterQuads);
        return WrappedIterator.createNoRemove((Iterator)iterTriples);
    }

    protected static ExtendedIterator<Triple> graphBaseFindNG(DatasetGraphTDB dataset, Node graphNode, TripleMatch m) {
        Iterator<Quad> iter;
        Node gn = graphNode;
        if (GraphTDB.isUnionGraph((Node)gn)) {
            gn = Node.ANY;
        }
        if ((iter = dataset.getQuadTable().find(gn, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) == null) {
            return NullIterator.instance();
        }
        Iterator<Triple> iterTriples = new ProjectQuadsToTriples(gn == Node.ANY ? null : gn, iter);
        if (gn == Node.ANY) {
            iterTriples = Iter.distinct((Iterator)iterTriples);
        }
        return WrappedIterator.createNoRemove((Iterator)iterTriples);
    }

    protected ExtendedIterator<Triple> graphUnionFind(Node s, Node p, Node o) {
        Node g = Quad.unionGraph;
        Iterator iterQuads = this.getDSG().find(g, s, p, o);
        Object iter = GLib.quads2triples((Iterator)iterQuads);
        iter = Iter.distinctAdjacent((Iterator)iter);
        return WrappedIterator.createNoRemove((Iterator)iter);
    }

    public void startRead() {
        this.getDSG().startRead();
    }

    public void finishRead() {
        this.getDSG().finishRead();
    }

    public final void startUpdate() {
        this.getDSG().startUpdate();
    }

    public final void finishUpdate() {
        this.getDSG().finishUpdate();
    }

    protected final int graphBaseSize() {
        if (this.isDefaultGraph()) {
            return (int)this.getNodeTupleTable().size();
        }
        Node gn = this.getGraphName();
        boolean unionGraph = GraphTDB.isUnionGraph((Node)gn);
        gn = unionGraph ? Node.ANY : gn;
        Iterator iter = this.getDSG().getQuadTable().getNodeTupleTable().findAsNodeIds(gn, null, null, null);
        if (unionGraph) {
            iter = Iter.map(iter, project4TupleTo3Tuple);
            iter = Iter.distinctAdjacent((Iterator)iter);
        }
        return (int)Iter.count(iter);
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                public boolean sizeAccurate() {
                    return true;
                }

                public boolean addAllowed() {
                    return true;
                }

                public boolean addAllowed(boolean every) {
                    return true;
                }

                public boolean deleteAllowed() {
                    return true;
                }

                public boolean deleteAllowed(boolean every) {
                    return true;
                }

                public boolean canBeEmpty() {
                    return true;
                }

                public boolean iteratorRemoveAllowed() {
                    return false;
                }

                public boolean findContractSafe() {
                    return true;
                }

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return super.getCapabilities();
    }

    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.bulkUpdateHandler;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public void clear() {
        this.dataset.deleteAny(this.getGraphName(), Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent((Graph)this, (Object)GraphEvents.removeAll);
    }

    public void remove(Node s, Node p, Node o) {
        if (this.getEventManager().listening()) {
            super.remove(s, p, o);
            return;
        }
        this.dataset.deleteAny(this.getGraphName(), s, p, o);
    }

    static class ProjectQuadsToTriples
    implements Iterator<Triple> {
        private final Iterator<Quad> iter;
        private final Node graphNode;

        ProjectQuadsToTriples(Node graphNode, Iterator<Quad> iter) {
            this.graphNode = graphNode;
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Triple next() {
            Quad q = this.iter.next();
            if (this.graphNode != null && !q.getGraph().equals((Object)this.graphNode)) {
                throw new InternalError("ProjectQuadsToTriples: Quads from unexpected graph (expected=" + this.graphNode + ", got=" + q.getGraph() + ")");
            }
            return q.asTriple();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

