/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.sys.Names;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;

public class FileRef {
    private final String filename;
    private final int id;
    static final int idxOffset = 10;
    static final String journalName = "journal";
    static final int journalIdx = 9;
    static Map<String, Integer> name2id = new HashMap<String, Integer>();
    static Map<Integer, FileRef> id2name = new TreeMap<Integer, FileRef>();
    public static final FileRef Journal;

    private static void printTable() {
        for (String name : Names.tripleIndexes) {
            FileRef.bTree(name);
        }
        for (String name : Names.quadIndexes) {
            FileRef.bTree(name);
        }
        FileRef.bTree("prefixes");
        FileRef.bTree("prefix2id");
        FileRef.file("nodes.dat");
        FileRef.bTree("node2id");
        FileRef.bTree("prefixIdx");
        for (Map.Entry<Integer, FileRef> e : id2name.entrySet()) {
            System.out.printf("    add(%s+idxOffset , %s) ;\n", e.getKey() - 10, '\"' + e.getValue().filename + '\"');
        }
    }

    public static void register(String fn) {
        FileRef.file(fn);
    }

    private static void add(int idx, String fn) {
        name2id.put(fn, idx);
        id2name.put(idx, new FileRef(fn, idx));
    }

    private static void bTree(String name) {
        FileRef.file(name + ".idn");
        FileRef.file(name + ".dat");
    }

    public static void file(String name) {
        int idx = name2id.size() + 10;
        FileRef.add(idx, name);
    }

    public static FileRef create(FileSet fileSet, String ext) {
        return FileRef.create(fileSet.filename(ext));
    }

    public static FileRef create(String filename) {
        Tuple x = FileOps.splitDirFile((String)filename);
        String key = (String)x.get(1);
        if (!name2id.containsKey(key)) {
            Log.warn(FileRef.class, (String)("File name not registered: " + filename));
            FileRef.file(key);
        }
        return new FileRef(key, name2id.get(key));
    }

    public static FileRef get(int fileId) {
        FileRef f = id2name.get(fileId);
        if (f == null) {
            Log.fatal(FileRef.class, (String)("No FileRef registered for id: " + fileId));
            throw new TDBException("No FileRef registered for id: " + fileId);
        }
        return f;
    }

    private FileRef(String filename, int id) {
        if (filename == null) {
            throw new IllegalArgumentException("Null for a FileRef filename");
        }
        this.filename = filename.intern();
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return "fileref(" + this.id + "):" + this.filename;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileRef other = (FileRef)obj;
        if (this.id != other.id) {
            return false;
        }
        return Lib.equal((Object)this.filename, (Object)other.filename);
    }

    static {
        FileRef.add(9, journalName);
        FileRef.file("SPO.idn");
        FileRef.file("SPO.dat");
        FileRef.file("POS.idn");
        FileRef.file("POS.dat");
        FileRef.file("OSP.idn");
        FileRef.file("OSP.dat");
        FileRef.file("GSPO.idn");
        FileRef.file("GSPO.dat");
        FileRef.file("GPOS.idn");
        FileRef.file("GPOS.dat");
        FileRef.file("GOSP.idn");
        FileRef.file("GOSP.dat");
        FileRef.file("POSG.idn");
        FileRef.file("POSG.dat");
        FileRef.file("OSPG.idn");
        FileRef.file("OSPG.dat");
        FileRef.file("SPOG.idn");
        FileRef.file("SPOG.dat");
        FileRef.file("prefixes.idn");
        FileRef.file("prefixes.dat");
        FileRef.file("prefix2id.idn");
        FileRef.file("prefix2id.dat");
        FileRef.file("nodes.dat");
        FileRef.file("node2id.idn");
        FileRef.file("node2id.dat");
        FileRef.file("prefixIdx.idn");
        FileRef.file("prefixIdx.dat");
        FileRef.add(1010, "TEST");
        FileRef.add(1011, "TEST1");
        FileRef.add(1012, "TEST2");
        Journal = FileRef.get(9);
    }
}

