/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj;

import de.hshannover.f4.trust.ifmapj.exception.InitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class IfmapJHelper {
    public static KeyManager[] getKeyManagers() throws InitializationException {
        String file = System.getProperty("javax.net.ssl.keyStore");
        String pass = System.getProperty("javax.net.ssl.keyStorePassword");
        if (file == null || pass == null) {
            throw new InitializationException("javax.net.ssl.keyStore / javax.net.ssl.keyStorePassword not set");
        }
        return IfmapJHelper.getKeyManagers(file, pass);
    }

    public static KeyManager[] getKeyManagers(String keyStoreFile, String pass) throws InitializationException {
        return IfmapJHelper.getKeyManagers(IfmapJHelper.getFileAsInputStream(keyStoreFile), pass);
    }

    public static KeyManager[] getKeyManagers(InputStream keyStoreIs, String pass) throws InitializationException {
        if (keyStoreIs == null || pass == null) {
            throw new NullPointerException("parameters null?");
        }
        try {
            String defaultAlgo = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(defaultAlgo);
            KeyStore ks = IfmapJHelper.loadKeyStore(keyStoreIs, pass);
            kmf.init(ks, pass.toCharArray());
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new InitializationException(e.getMessage());
        }
    }

    public static TrustManager[] getTrustManagers() throws InitializationException {
        String file = System.getProperty("javax.net.ssl.trustStore");
        String pass = System.getProperty("javax.net.ssl.trustStorePassword");
        if (file == null || pass == null) {
            throw new InitializationException("javax.net.ssl.trustStore / javax.net.ssl.trustStorePassword not set");
        }
        return IfmapJHelper.getTrustManagers(file, pass);
    }

    public static TrustManager[] getTrustManagers(String trustStorePath, String pass) throws InitializationException {
        return IfmapJHelper.getTrustManagers(IfmapJHelper.getFileAsInputStream(trustStorePath), pass);
    }

    public static TrustManager[] getTrustManagers(InputStream trustStoreIs, String pass) throws InitializationException {
        if (trustStoreIs == null || pass == null) {
            throw new NullPointerException("parameters null?");
        }
        try {
            String defaultAlgo = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(defaultAlgo);
            KeyStore ks = IfmapJHelper.loadKeyStore(trustStoreIs, pass);
            tmf.init(ks);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            throw new InitializationException(e.getMessage());
        }
    }

    private static KeyStore loadKeyStore(InputStream is, String pass) throws InitializationException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(is, pass.toCharArray());
        return ks;
    }

    private static InputStream getFileAsInputStream(String file) throws InitializationException {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        try {
            return new FileInputStream(new File(file));
        }
        catch (FileNotFoundException e) {
            throw new InitializationException("File not found: " + file);
        }
    }
}

