/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.channel;

import de.hshannover.f4.trust.ifmapj.channel.CommunicationHandler;
import de.hshannover.f4.trust.ifmapj.channel.CommunicationHandlerFactory;
import de.hshannover.f4.trust.ifmapj.channel.IfmapChannel;
import de.hshannover.f4.trust.ifmapj.exception.CommunicationException;
import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.IfmapException;
import de.hshannover.f4.trust.ifmapj.exception.InitializationException;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.log.IfmapJLog;
import de.hshannover.f4.trust.ifmapj.messages.Request;
import de.hshannover.f4.trust.ifmapj.messages.RequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.Result;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

abstract class AbstractChannel
implements IfmapChannel {
    public static final String VERIFY_PEER_CERT_PROPERTY = "ifmapj.communication.verifypeercert";
    public static final String VERIFY_PEER_HOST_PROPERTY = "ifmapj.communication.verifypeerhost";
    private final CommunicationHandler mCommunicationHandler;
    private final String mUrlStr;
    private final String mUser;
    private final String mPassword;
    private final boolean mBasicAuth;
    private final DocumentBuilder mDocumentBuilder;
    protected final int mInitialConnectionTimeout;

    private AbstractChannel(String url, String user, String pass, KeyManager[] kms, TrustManager[] tms, int initialConnectionTimeout) throws InitializationException {
        this.mInitialConnectionTimeout = initialConnectionTimeout;
        if (url == null) {
            throw new InitializationException("URL not allowed to be null");
        }
        if (tms == null) {
            throw new InitializationException("keystore and truststore need to be set");
        }
        if (user != null && pass == null || user == null && pass != null) {
            throw new InitializationException("One basic auth parameter is null");
        }
        this.mUrlStr = url;
        this.mUser = user;
        this.mPassword = pass;
        this.mBasicAuth = this.mUser != null || this.mPassword != null;
        this.mDocumentBuilder = DomHelpers.newDocumentBuilder();
        SSLSocketFactory sslSocketFactory = this.initSslSocketFactory(kms, tms);
        HostnameVerifier verifier = this.initHostnameVerifier();
        this.mCommunicationHandler = CommunicationHandlerFactory.newHandler(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
    }

    AbstractChannel(String url, String user, String pass, TrustManager[] tms, int initialConnectionTimeout) throws InitializationException {
        this(url, user, pass, null, tms, initialConnectionTimeout);
    }

    AbstractChannel(String url, KeyManager[] kms, TrustManager[] tms, int initialConnectionTimeout) throws InitializationException {
        this(url, null, null, kms, tms, initialConnectionTimeout);
    }

    @Override
    public final Result genericRequestWithSessionId(Request req) throws IfmapErrorResult, IfmapException {
        if (this.getSessionId() == null) {
            throw new IfmapException("no session-id", "session-id not set for channel");
        }
        req.setSessionId(this.getSessionId());
        return this.genericRequest(req);
    }

    @Override
    public final Result genericRequest(Request req) throws IfmapErrorResult, IfmapException {
        RequestHandler<? extends Request> reqhandler = Requests.getHandlerFor(req);
        if (reqhandler == null) {
            throw new MarshalException("No handler for " + req.getClass());
        }
        Document docReq = this.mDocumentBuilder.newDocument();
        Element elBody = this.addSoapEnvelopeBody(docReq);
        Element content = reqhandler.toElement(req, docReq);
        elBody.appendChild(content);
        Document docRes = this.parseDocument(this.doHttpRequest(DomHelpers.toInputStream(docReq)));
        return reqhandler.fromElement(this.findResponseElement(docRes));
    }

    private Element addSoapEnvelopeBody(Document doc) {
        Element env = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "soap:Envelope");
        Element body = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "soap:Body");
        doc.appendChild(env);
        env.appendChild(body);
        return body;
    }

    private Document parseDocument(InputStream is) throws UnmarshalException {
        try {
            return this.mDocumentBuilder.parse(is);
        }
        catch (Exception e) {
            IfmapJLog.error("Parsing Exception occurred [" + e.getMessage() + "]");
            throw new UnmarshalException(e.getMessage());
        }
    }

    private Element findResponseElement(Document doc) throws UnmarshalException {
        Element env = DomHelpers.findElementInChildren(doc, "Envelope", "http://www.w3.org/2003/05/soap-envelope");
        if (env == null) {
            throw new UnmarshalException("Could not find SOAP Envelope");
        }
        Element body = DomHelpers.findElementInChildren(env, "Body", "http://www.w3.org/2003/05/soap-envelope");
        if (body == null) {
            throw new UnmarshalException("Could not find SOAP Body");
        }
        Element response = DomHelpers.findElementInChildren(body, "response", "http://www.trustedcomputinggroup.org/2010/IFMAP/2");
        if (response == null) {
            throw new UnmarshalException("Could not find IF-MAP response element");
        }
        return response;
    }

    private InputStream doHttpRequest(InputStream is) throws CommunicationException {
        return this.mCommunicationHandler.doRequest(is);
    }

    public String getUrl() {
        return this.mUrlStr;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    @Override
    public void setGzip(boolean useGzip) {
        this.mCommunicationHandler.setGzip(useGzip);
    }

    @Override
    public boolean usesGzip() {
        return this.mCommunicationHandler.usesGzip();
    }

    public boolean isBasicAuth() {
        return this.mBasicAuth;
    }

    @Override
    public void closeTcpConnection() throws CommunicationException {
        this.mCommunicationHandler.closeTcpConnection();
    }

    private SSLSocketFactory initSslSocketFactory(KeyManager[] kms, TrustManager[] tms) throws InitializationException {
        SSLContext ctx = null;
        String verify = System.getProperty(VERIFY_PEER_CERT_PROPERTY);
        if (verify != null && verify.equals("false")) {
            tms = this.getTrustAllKeystore();
        } else if (!(verify == null || verify != null && verify.equals("true"))) {
            throw new InitializationException("Bad value for ifmapj.communication.verifypeercert property. Expected: true|false");
        }
        if (!this.isBasicAuth() && kms == null) {
            throw new InitializationException("certificate-based auth needs a KeyManager");
        }
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(kms, tms, new SecureRandom());
        }
        catch (Exception e) {
            IfmapJLog.error("Could not initialize SSLSocketFactory [" + e.getMessage() + "]");
            throw new InitializationException(e);
        }
        return ctx.getSocketFactory();
    }

    private TrustManager[] getTrustAllKeystore() {
        return new TrustManager[]{new TrustAllManager()};
    }

    private HostnameVerifier initHostnameVerifier() {
        String verify = System.getProperty(VERIFY_PEER_HOST_PROPERTY);
        if (verify != null && verify.equals("true")) {
            return new X509CommonNameHostnameVerifier();
        }
        return new AllOkHostnameVerifier();
    }

    private class X509CommonNameHostnameVerifier
    implements HostnameVerifier {
        private X509CommonNameHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            InetAddress[] certIps;
            InetAddress[] hostIps;
            Certificate[] certs;
            X509Certificate cert0 = null;
            X500Principal principal = null;
            String name = null;
            String certCn = null;
            try {
                certs = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                return false;
            }
            if (certs.length == 0) {
                return false;
            }
            if (!(certs[0] instanceof X509Certificate)) {
                return false;
            }
            cert0 = (X509Certificate)certs[0];
            principal = cert0.getSubjectX500Principal();
            if (principal == null) {
                return false;
            }
            name = principal.getName();
            if (!name.startsWith("CN=")) {
                return false;
            }
            int idx = name.indexOf(44);
            if (idx < 0 || idx < 3) {
                return false;
            }
            certCn = name.substring(3, idx);
            try {
                hostIps = InetAddress.getAllByName(hostname);
                certIps = InetAddress.getAllByName(certCn);
            }
            catch (UnknownHostException e) {
                return false;
            }
            for (InetAddress hostIp : hostIps) {
                for (InetAddress certIp : certIps) {
                    if (!hostIp.equals(certIp)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class AllOkHostnameVerifier
    implements HostnameVerifier {
        private AllOkHostnameVerifier() {
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }

    private class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

