/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.channel;

import de.hshannover.f4.trust.ifmapj.channel.ARC;
import de.hshannover.f4.trust.ifmapj.channel.AbstractChannel;
import de.hshannover.f4.trust.ifmapj.channel.SSRC;
import de.hshannover.f4.trust.ifmapj.exception.EndSessionException;
import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.IfmapException;
import de.hshannover.f4.trust.ifmapj.exception.InitializationException;
import de.hshannover.f4.trust.ifmapj.messages.PollRequest;
import de.hshannover.f4.trust.ifmapj.messages.PollResult;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.Result;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public class ArcImpl
extends AbstractChannel
implements ARC {
    private final SSRC mSsrc;

    ArcImpl(SSRC ssrc, String url, KeyManager[] kms, TrustManager[] tms, int initialConnectionTimeout) throws InitializationException {
        super(url, kms, tms, initialConnectionTimeout);
        if (ssrc == null) {
            throw new NullPointerException("Need a valid SSRC instance");
        }
        this.mSsrc = ssrc;
    }

    ArcImpl(SSRC ssrc, String url, String user, String password, TrustManager[] tms, int initialConnectionTimeout) throws InitializationException {
        super(url, user, password, tms, initialConnectionTimeout);
        if (ssrc == null) {
            throw new NullPointerException("Need a valid SSRC instance");
        }
        this.mSsrc = ssrc;
    }

    @Override
    public PollResult poll() throws IfmapErrorResult, EndSessionException, IfmapException {
        PollRequest pollReq = Requests.createPollReq();
        Result res = this.genericRequestWithSessionId(pollReq);
        if (res instanceof EndSessionException) {
            throw (EndSessionException)res;
        }
        if (!(res instanceof PollResult)) {
            throw new RuntimeException("Wrong result type for poll?");
        }
        return (PollResult)res;
    }

    @Override
    public String getSessionId() {
        return this.mSsrc.getSessionId();
    }

    @Override
    public String getPublisherId() {
        return this.mSsrc.getPublisherId();
    }

    @Override
    public Integer getMaxPollResSize() {
        return this.mSsrc.getMaxPollResSize();
    }

    @Override
    public void setSessionId(String sessionId) {
        this.mSsrc.setSessionId(sessionId);
    }

    @Override
    public void setPublisherId(String publisherId) {
        this.mSsrc.setPublisherId(publisherId);
    }

    @Override
    public void setMaxPollResSize(Integer mprs) {
        this.mSsrc.setMaxPollResSize(mprs);
    }
}

