/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.channel;

import de.hshannover.f4.trust.ifmapj.channel.ApacheCoreCommunicationHandler;
import de.hshannover.f4.trust.ifmapj.channel.CommunicationHandler;
import de.hshannover.f4.trust.ifmapj.channel.JavaCommunicationHandler;
import de.hshannover.f4.trust.ifmapj.exception.InitializationException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public abstract class CommunicationHandlerFactory {
    public static final String HANDLER_PROPERTY = "ifmapj.communication.handler";

    public static CommunicationHandler newHandler(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier, int initialConnectionTimeout) throws InitializationException {
        String handler = System.getProperty(HANDLER_PROPERTY);
        if (handler != null) {
            return CommunicationHandlerFactory.newHandlerPreference(handler, url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
        }
        return CommunicationHandlerFactory.newHandlerAuto(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
    }

    private static CommunicationHandler newHandlerAuto(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier, int initialConnectionTimeout) throws InitializationException {
        try {
            return new ApacheCoreCommunicationHandler(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
        }
        catch (NoClassDefFoundError e) {
            return new JavaCommunicationHandler(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
        }
    }

    private static CommunicationHandler newHandlerPreference(String handlerProp, String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier, int initialConnectionTimeout) throws InitializationException {
        if (handlerProp == null) {
            throw new NullPointerException();
        }
        if (handlerProp.equals("java")) {
            return new JavaCommunicationHandler(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
        }
        if (handlerProp.equals("apache")) {
            try {
                return new ApacheCoreCommunicationHandler(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
            }
            catch (NoClassDefFoundError e) {
                throw new InitializationException("Could not initialize ApacheCommunicationHandler");
            }
        }
        throw new InitializationException("Invalid ifmapj.communication.handler value");
    }
}

