/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.channel;

import de.hshannover.f4.trust.ifmapj.channel.AbstractCommunicationHandler;
import de.hshannover.f4.trust.ifmapj.exception.CommunicationException;
import de.hshannover.f4.trust.ifmapj.exception.InitializationException;
import de.hshannover.f4.trust.ifmapj.log.IfmapJLog;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

class JavaCommunicationHandler
extends AbstractCommunicationHandler {
    private OutputStream mOutputStream;
    private InputStream mInputStream;
    private DataOutput mDataOutputStream;
    private DataInput mDataInputStream;
    private Map<String, String> mReceivedHeaders;
    private byte[] mBuffer = new byte[1024];

    JavaCommunicationHandler(String url, String user, String pass, SSLSocketFactory sslSocketFactory, HostnameVerifier verifier, int initialConnectionTimeout) throws InitializationException {
        super(url, user, pass, sslSocketFactory, verifier, initialConnectionTimeout);
        this.mReceivedHeaders = new HashMap<String, String>(10);
    }

    @Override
    public InputStream doActualRequest(InputStream is) throws IOException, CommunicationException {
        StatusLine statusLine = null;
        int retLength = -1;
        this.sendHttpBody(is);
        statusLine = this.readStatusLine();
        this.checkStatusLine(statusLine);
        this.receiveHeaders();
        if (this.responseIsChunked()) {
            retLength = this.readChunkedBody();
        } else if (this.responseContainsContentLength()) {
            retLength = this.readContinuousBody();
        } else {
            throw new CommunicationException("Could not determine length of body");
        }
        return new ByteArrayInputStream(this.mBuffer, 0, retLength);
    }

    private int readChunkedBody() throws CommunicationException, IOException {
        String chunkLengthLine = null;
        String tmpLine = null;
        int curOffset = 0;
        int curChunkLength = -1;
        while ((chunkLengthLine = this.mDataInputStream.readLine()) != null) {
            if (chunkLengthLine.length() == 0) {
                throw new CommunicationException("Unexpected empty chunk length");
            }
            curChunkLength = this.parseChunkLength(chunkLengthLine);
            if (curChunkLength == 0) break;
            this.reallocateBuffer(this.mBuffer.length + 2 * curChunkLength);
            this.readStreamIntoBuffer(this.mInputStream, curOffset, curChunkLength);
            curOffset += curChunkLength;
            tmpLine = this.mDataInputStream.readLine();
            if (tmpLine != null && tmpLine.length() <= 0) continue;
            throw new CommunicationException("Unexpected chunk ending: " + tmpLine);
        }
        while ((tmpLine = this.mDataInputStream.readLine()) != null && tmpLine.length() != 0) {
        }
        return curOffset;
    }

    private int parseChunkLength(String chunkLengthLine) throws CommunicationException {
        String[] lengthStrElements = chunkLengthLine.split(" ");
        if (lengthStrElements.length < 1) {
            throw new CommunicationException("No chunk length included: " + chunkLengthLine);
        }
        try {
            return Integer.parseInt(lengthStrElements[0], 16);
        }
        catch (NumberFormatException e) {
            throw new CommunicationException("Could not parse chunk length");
        }
    }

    private boolean responseContainsContentLength() {
        return this.findHeaderValue("Content-Length") != null;
    }

    private boolean responseIsChunked() {
        String teHeader = this.findHeaderValue("Transfer-Encoding");
        return teHeader != null && teHeader.contains("chunked");
    }

    @Override
    protected void prepareCommunication() throws IOException {
        if (this.mOutputStream != null && this.mInputStream != null) {
            return;
        }
        this.mOutputStream = this.getSocket().getOutputStream();
        this.mInputStream = this.getSocket().getInputStream();
        this.mDataOutputStream = new DataOutputStream(this.mOutputStream);
        this.mDataInputStream = new DataInputStream(this.mInputStream);
    }

    @Override
    protected void createPostRequest(String path) throws IOException {
        this.mReceivedHeaders.clear();
        this.writeLine("POST " + path + " HTTP/1.1");
    }

    @Override
    protected void addHeader(String key, String value) throws IOException {
        this.writeHeaderLine(key, value);
    }

    @Override
    protected void finishHeaders() throws IOException {
        this.writeHeaderEnding();
    }

    @Override
    protected boolean replyIsGzipped() throws IOException {
        String encodingHdr = this.findHeaderValue("Content-Encoding");
        return encodingHdr != null && encodingHdr.contains("gzip");
    }

    private void sendHttpBody(InputStream is) throws IOException {
        int length = is.available();
        this.allocateBuffer(length);
        this.readStreamIntoBuffer(is, length);
        this.sendBufferContents(length);
    }

    private void writeHeaderLine(String key, String value) throws IOException {
        this.writeLine(key + ": " + value);
    }

    private void writeHeaderEnding() throws IOException {
        this.writeLine("");
        this.mOutputStream.flush();
    }

    private void writeLine(String line) throws IOException {
        this.mDataOutputStream.write((line + "\r\n").getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeTcpConnectionImpl() throws IOException {
        IOException tmp = null;
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        catch (IOException e) {
            if (tmp == null) {
                tmp = e;
            }
        }
        finally {
            this.mInputStream = null;
        }
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
        }
        catch (IOException e) {
            if (tmp != null) {
                tmp = e;
            }
        }
        finally {
            this.mOutputStream = null;
        }
        this.mDataOutputStream = null;
        this.mDataInputStream = null;
        if (tmp != null) {
            throw tmp;
        }
    }

    private int getContentLength() throws CommunicationException {
        String lengthHdr = this.findHeaderValue("Content-Length");
        if (lengthHdr == null) {
            throw new CommunicationException("No Content-Length header found");
        }
        return this.parseContentLengthHeader(lengthHdr);
    }

    private int parseContentLengthHeader(String lengthHdr) throws CommunicationException {
        try {
            return Integer.parseInt(lengthHdr);
        }
        catch (NumberFormatException e) {
            throw new CommunicationException("Content-Length invalid: \"" + lengthHdr + "\"");
        }
    }

    private String findHeaderValue(String hdrField) {
        for (String hdr : this.mReceivedHeaders.keySet()) {
            if (!hdr.equalsIgnoreCase(hdrField)) continue;
            return this.mReceivedHeaders.get(hdr);
        }
        return null;
    }

    private void receiveHeaders() throws CommunicationException, IOException {
        String line = null;
        this.mReceivedHeaders.clear();
        while (this.mDataInputStream.readLine() != null && line.length() > 0) {
            line = this.mDataInputStream.readLine();
            String[] fields = line.split(":", 2);
            if (fields.length < 2) {
                throw new CommunicationException("Invalid Header Received: " + line);
            }
            fields[0] = fields[0].replaceAll("^\\s+", "");
            fields[0] = fields[0].replaceAll("\\s+$", "");
            fields[1] = fields[1].replaceAll("^\\s+", "");
            fields[1] = fields[1].replaceAll("\\s+$", "");
            this.mReceivedHeaders.put(fields[0], fields[1]);
        }
        if (line == null) {
            throw new CommunicationException("Unexpected EOF reached");
        }
    }

    private StatusLine readStatusLine() throws CommunicationException, IOException {
        StatusLine ret = new StatusLine();
        String line = this.mDataInputStream.readLine();
        if (line == null) {
            throw new CommunicationException("No status line received");
        }
        String[] fields = line.split(" ", 3);
        if (fields.length < 2) {
            throw new CommunicationException("Bad status line received");
        }
        String proto = fields[0];
        if (!proto.equals("HTTP/1.1")) {
            throw new CommunicationException("Communication not HTTP/1.1");
        }
        try {
            ret.mStatusCode = Integer.parseInt(fields[1]);
        }
        catch (NumberFormatException e) {
            throw new CommunicationException("Bad status code received");
        }
        if (fields.length == 3) {
            ret.mReason = fields[2];
        }
        return ret;
    }

    private int readContinuousBody() throws IOException, CommunicationException {
        int length = this.getContentLength();
        this.allocateBuffer(length);
        this.readStreamIntoBuffer(this.mInputStream, length);
        return length;
    }

    private void checkStatusLine(StatusLine status) throws CommunicationException {
        if (status.mStatusCode != 200) {
            IfmapJLog.warn("HTTP Status Code: " + status.mStatusCode + " " + status.mReason);
            throw new CommunicationException("HTTP Status Code: " + status.mStatusCode + " " + status.mReason);
        }
    }

    private void sendBufferContents(int length) throws IOException {
        this.mOutputStream.write(this.mBuffer, 0, length);
        this.mOutputStream.flush();
    }

    private void readStreamIntoBuffer(InputStream is, int length) throws IOException {
        this.readStreamIntoBuffer(is, 0, length);
    }

    private void readStreamIntoBuffer(InputStream is, int off, int length) throws IOException {
        int ret;
        for (int read = 0; read < length; read += ret) {
            ret = is.read(this.mBuffer, read + off, length - read);
            if (ret != -1) continue;
            throw new IOException("Stream exception");
        }
    }

    private void allocateBuffer(int newLength) {
        this.allocateBuffer(newLength, false);
    }

    private void reallocateBuffer(int newLength) {
        this.allocateBuffer(newLength, true);
    }

    private void allocateBuffer(int newLength, boolean copy) {
        if (newLength > this.mBuffer.length) {
            byte[] tmp = this.mBuffer;
            this.mBuffer = new byte[newLength];
            if (copy) {
                System.arraycopy(tmp, 0, this.mBuffer, 0, tmp.length);
            }
        }
    }

    private class StatusLine {
        public int mStatusCode;
        public String mReason;

        private StatusLine() {
        }
    }
}

