/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.identifier;

import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.AccessRequest;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.IdentifierHandler;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class AccessRequestHandler
implements IdentifierHandler<AccessRequest> {
    AccessRequestHandler() {
    }

    @Override
    public Element toElement(Identifier i, Document doc) throws MarshalException {
        Identifiers.Helpers.checkIdentifierType(i, this);
        AccessRequest ar = (AccessRequest)i;
        String name = ar.getName();
        if (name == null) {
            throw new MarshalException("AccessRequest with null name not allowed");
        }
        if (name.length() == 0) {
            throw new MarshalException("AccessRequest with empty name not allowed");
        }
        Element ret = DomHelpers.createNonNsElement(doc, "access-request");
        DomHelpers.addAttribute(ret, "name", name);
        Identifiers.Helpers.addAdministrativeDomain(ret, ar);
        return ret;
    }

    @Override
    public AccessRequest fromElement(Element el) throws UnmarshalException {
        String name = null;
        if (!DomHelpers.elementMatches(el, "access-request")) {
            return null;
        }
        name = el.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new UnmarshalException("No or empty name found for access-request");
        }
        return Identifiers.createAr(name, Identifiers.Helpers.getAdministrativeDomain(el));
    }

    @Override
    public Class<AccessRequest> handles() {
        return AccessRequest.class;
    }
}

