/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.identifier;

import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.Device;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.IdentifierHandler;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import util.DomHelpers;

class DeviceHandler
implements IdentifierHandler<Device> {
    DeviceHandler() {
    }

    @Override
    public Element toElement(Identifier i, Document doc) throws MarshalException {
        Identifiers.Helpers.checkIdentifierType(i, this);
        Device dev = (Device)i;
        String name = dev.getName();
        if (name == null) {
            throw new MarshalException("Device with null name not allowed");
        }
        if (name.length() == 0) {
            throw new MarshalException("Device with empty name not allowed");
        }
        Element ret = DomHelpers.createNonNsElement(doc, "device");
        Element nameEl = DomHelpers.createNonNsElement(doc, "name");
        Text text = doc.createTextNode(name);
        ret.appendChild(nameEl);
        nameEl.appendChild(text);
        return ret;
    }

    @Override
    public Device fromElement(Element el) throws UnmarshalException {
        Element child = null;
        String name = null;
        if (!DomHelpers.elementMatches(el, "device")) {
            return null;
        }
        List<Element> children = DomHelpers.getChildElements(el);
        if (children.size() != 1) {
            throw new UnmarshalException("Bad device element? Has " + children.size() + " child elements.");
        }
        child = children.get(0);
        if (!DomHelpers.elementMatches(child, "name")) {
            throw new UnmarshalException("Unknown child element in device element: " + child.getLocalName());
        }
        name = child.getTextContent();
        if (name == null || name.length() == 0) {
            throw new UnmarshalException("No text content found");
        }
        return Identifiers.createDev(name);
    }

    @Override
    public Class<Device> handles() {
        return Device.class;
    }
}

