/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.identifier;

import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.IdentifierWithAd;
import de.hshannover.f4.trust.ifmapj.identifier.IdentityType;
import javax.security.auth.x500.X500Principal;
import util.DomHelpers;
import util.StringHelpers;

public class Identity
extends IdentifierWithAd {
    private String mName;
    private IdentityType mType;
    private String mOtherTypeDefinition;

    Identity(IdentityType type, String name, String admDom, String otherTypeDef) {
        super(admDom);
        this.mType = type;
        this.mOtherTypeDefinition = otherTypeDef;
        this.setName(name);
    }

    public String getName() {
        return this.mName;
    }

    @Deprecated
    public final void setName(String name) {
        if (name == null || this.mType == null) {
            this.mName = name;
            return;
        }
        if (this.mType.equals((Object)IdentityType.dnsName) || this.mType.equals((Object)IdentityType.telUri)) {
            this.mName = name.toLowerCase();
        } else if (this.mType.equals((Object)IdentityType.emailAddress) && StringHelpers.getStringCharCount(name, '@') == 1) {
            String[] parts = name.split("@");
            this.mName = parts[0] + "@" + parts[1].toLowerCase();
        } else {
            this.mName = this.mType.equals((Object)IdentityType.hipHit) ? name.toLowerCase() : name;
        }
    }

    public IdentityType getType() {
        return this.mType;
    }

    @Deprecated
    public void setType(IdentityType type) {
        this.mType = type;
    }

    public String getOtherTypeDefinition() {
        return this.mOtherTypeDefinition;
    }

    @Deprecated
    public void setOtherTypeDefinition(String otherTypeDefinition) {
        this.mOtherTypeDefinition = otherTypeDefinition;
    }

    @Override
    public String toString() {
        String otherTypeDef = "";
        if (this.getType() == IdentityType.other) {
            otherTypeDef = ", " + this.getOtherTypeDefinition();
        }
        return String.format("id{%s, %s%s%s}", new Object[]{this.getName(), this.getType(), otherTypeDef, super.toString()});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mOtherTypeDefinition == null ? 0 : this.mOtherTypeDefinition.hashCode());
        result = 31 * result + (this.mType == null ? 0 : this.mType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identity other = (Identity)obj;
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        if (this.mOtherTypeDefinition == null ? other.mOtherTypeDefinition != null : !this.mOtherTypeDefinition.equals(other.mOtherTypeDefinition)) {
            return false;
        }
        return this.mType == other.mType;
    }

    private boolean extendedIdentifierEquals(String eid1, String eid2) {
        try {
            return DomHelpers.compare(DomHelpers.toDocument(eid1, null), DomHelpers.toDocument(eid2, null));
        }
        catch (MarshalException e) {
            return false;
        }
    }

    private boolean distinguishedNameEquals(String dsn1, String dsn2) {
        return new X500Principal(dsn1).equals(new X500Principal(dsn2));
    }
}

