/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.identifier;

import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.IdentifierHandler;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import de.hshannover.f4.trust.ifmapj.identifier.Identity;
import de.hshannover.f4.trust.ifmapj.identifier.IdentityType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class IdentityHandler
implements IdentifierHandler<Identity> {
    IdentityHandler() {
    }

    @Override
    public Element toElement(Identifier i, Document doc) throws MarshalException {
        Identifiers.Helpers.checkIdentifierType(i, this);
        Identity id = (Identity)i;
        String name = id.getName();
        IdentityType type = id.getType();
        String otherTypeDef = id.getOtherTypeDefinition();
        if (type == null) {
            throw new MarshalException("No Identity type set");
        }
        if (name == null) {
            throw new MarshalException("Identity with null name not allowed");
        }
        if (name.length() == 0) {
            throw new MarshalException("Identity with empty name not allowed");
        }
        Element ret = DomHelpers.createNonNsElement(doc, "identity");
        DomHelpers.addAttribute(ret, "name", name);
        DomHelpers.addAttribute(ret, "type", type.toString());
        if (type == IdentityType.other) {
            if (otherTypeDef == null || otherTypeDef.length() == 0) {
                throw new MarshalException("Identity type=other requires other-type-definition");
            }
            DomHelpers.addAttribute(ret, "other-type-definition", otherTypeDef);
        } else if (otherTypeDef != null && otherTypeDef.length() > 0) {
            throw new MarshalException("Identity other-type-definition is set, but type != other");
        }
        Identifiers.Helpers.addAdministrativeDomain(ret, id);
        return ret;
    }

    @Override
    public Identity fromElement(Element el) throws UnmarshalException {
        IdentityType typeEnum = null;
        String name = null;
        String type = null;
        String otherTypeDef = null;
        if (!DomHelpers.elementMatches(el, "identity")) {
            return null;
        }
        name = el.getAttribute("name");
        type = el.getAttribute("type");
        otherTypeDef = el.getAttribute("other-type-definition");
        if (name == null || name.length() == 0) {
            throw new UnmarshalException("name not set or empty for identity");
        }
        if (type == null || type.length() == 0) {
            throw new UnmarshalException("type not set or empty for identity");
        }
        for (IdentityType t : IdentityType.values()) {
            if (!t.toString().equals(type)) continue;
            typeEnum = t;
            break;
        }
        if (typeEnum == null) {
            throw new UnmarshalException("Illegal value for type:" + type);
        }
        if (typeEnum == IdentityType.other && otherTypeDef.length() == 0) {
            throw new UnmarshalException("identity with type=other, butother-type-definition not set");
        }
        if (typeEnum != IdentityType.other && el.getAttributeNode("other-type-definition") != null) {
            throw new UnmarshalException("identity with other-type-definition set, but type not other");
        }
        return Identifiers.createIdentity(typeEnum, name, Identifiers.Helpers.getAdministrativeDomain(el), otherTypeDef);
    }

    @Override
    public Class<Identity> handles() {
        return Identity.class;
    }
}

