/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.identifier;

import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.IdentifierHandler;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import de.hshannover.f4.trust.ifmapj.identifier.IpAddress;
import de.hshannover.f4.trust.ifmapj.identifier.IpAddressType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class IpAddressHandler
implements IdentifierHandler<IpAddress> {
    IpAddressHandler() {
    }

    @Override
    public Element toElement(Identifier i, Document doc) throws MarshalException {
        Identifiers.Helpers.checkIdentifierType(i, this);
        IpAddress ip = (IpAddress)i;
        String value = ip.getValue();
        IpAddressType type = IpAddressType.IPv4;
        if (value == null) {
            throw new MarshalException("IpAddress with null value not allowed");
        }
        if (value.length() == 0) {
            throw new MarshalException("IpAddress with empty value not allowed");
        }
        Element ret = DomHelpers.createNonNsElement(doc, "ip-address");
        type = ip.getType() != null ? ip.getType() : type;
        DomHelpers.addAttribute(ret, "value", value);
        DomHelpers.addAttribute(ret, "type", type.toString());
        Identifiers.Helpers.addAdministrativeDomain(ret, ip);
        return ret;
    }

    @Override
    public IpAddress fromElement(Element el) throws UnmarshalException {
        String value = null;
        String type = null;
        IpAddressType typeEnum = IpAddressType.IPv4;
        if (!DomHelpers.elementMatches(el, "ip-address")) {
            return null;
        }
        value = el.getAttribute("value");
        if (el.getAttributeNode("type") != null) {
            type = el.getAttribute("type");
        }
        if (value == null || value.length() == 0) {
            throw new UnmarshalException("No or empty value for ip-address found");
        }
        if (type != null) {
            try {
                typeEnum = IpAddressType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                throw new UnmarshalException("Invalid type for ip-address found:" + type);
            }
        }
        return Identifiers.createIp(typeEnum, value, Identifiers.Helpers.getAdministrativeDomain(el));
    }

    @Override
    public Class<IpAddress> handles() {
        return IpAddress.class;
    }
}

