/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.identifier;

import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.IdentifierHandler;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import de.hshannover.f4.trust.ifmapj.identifier.MacAddress;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class MacAddressHandler
implements IdentifierHandler<MacAddress> {
    MacAddressHandler() {
    }

    @Override
    public Element toElement(Identifier i, Document doc) throws MarshalException {
        Identifiers.Helpers.checkIdentifierType(i, this);
        MacAddress mac = (MacAddress)i;
        String value = mac.getValue();
        if (value == null) {
            throw new MarshalException("MacAddress with null value not allowed");
        }
        if (value.length() == 0) {
            throw new MarshalException("MacAddress with empty value not allowed");
        }
        if (!Pattern.matches("^([0-9a-f]{2}[:]){5}([0-9a-f]{2})$", value)) {
            throw new MarshalException("MacAddress not valid");
        }
        Element ret = DomHelpers.createNonNsElement(doc, "mac-address");
        DomHelpers.addAttribute(ret, "value", value);
        Identifiers.Helpers.addAdministrativeDomain(ret, mac);
        return ret;
    }

    @Override
    public MacAddress fromElement(Element el) throws UnmarshalException {
        String value = null;
        if (!DomHelpers.elementMatches(el, "mac-address")) {
            return null;
        }
        value = el.getAttribute("value");
        if (value == null || value.length() == 0) {
            throw new UnmarshalException("No or empty value for mac-address found");
        }
        return Identifiers.createMac(value, Identifiers.Helpers.getAdministrativeDomain(el));
    }

    @Override
    public Class<MacAddress> handles() {
        return MacAddress.class;
    }
}

