/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.messages;

import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import de.hshannover.f4.trust.ifmapj.messages.DumpRequest;
import de.hshannover.f4.trust.ifmapj.messages.DumpResultImpl;
import de.hshannover.f4.trust.ifmapj.messages.Request;
import de.hshannover.f4.trust.ifmapj.messages.RequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.Result;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class DumpRequestHandler
implements RequestHandler<DumpRequest> {
    public static final String DUMP_REQ_EL_NAME = "dump";
    public static final String DUMP_REQ_IDENT_FILTER = "identifier";
    public static final String DUMP_RES_EL_NAME = "dumpResult";
    public static final String DUMP_RES_LAST_UPDATE_ATTRIB = "last-update";

    DumpRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        String identFilter = ((DumpRequest)req).getIdentifierFilter();
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFqName(DUMP_REQ_EL_NAME));
        if (identFilter != null) {
            DomHelpers.addAttribute(ret, DUMP_REQ_IDENT_FILTER, identFilter);
        }
        Requests.Helpers.addSessionId(ret, req);
        return ret;
    }

    @Override
    public Result fromElement(Element res) throws UnmarshalException, IfmapErrorResult {
        Element content = Requests.Helpers.getResponseContentErrorCheck(res);
        Attr lastUpdateNode = null;
        String lastUpdate = null;
        ArrayList<Identifier> resIdents = new ArrayList<Identifier>();
        if (!DomHelpers.elementMatches(content, DUMP_RES_EL_NAME)) {
            throw new UnmarshalException("No dumpResult element found");
        }
        lastUpdateNode = content.getAttributeNode(DUMP_RES_LAST_UPDATE_ATTRIB);
        if (lastUpdateNode == null) {
            throw new UnmarshalException("No last-update attribute in dumpResult element found");
        }
        lastUpdate = content.getAttribute(DUMP_RES_LAST_UPDATE_ATTRIB);
        List<Element> children = DomHelpers.getChildElements(content);
        for (Element child : children) {
            resIdents.add(Identifiers.fromElement(child));
        }
        return new DumpResultImpl(lastUpdate, resIdents);
    }

    @Override
    public Class<DumpRequest> handles() {
        return DumpRequest.class;
    }
}

