/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.messages;

import de.hshannover.f4.trust.ifmapj.exception.EndSessionException;
import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.messages.PollRequest;
import de.hshannover.f4.trust.ifmapj.messages.PollResultImpl;
import de.hshannover.f4.trust.ifmapj.messages.Request;
import de.hshannover.f4.trust.ifmapj.messages.RequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.Result;
import de.hshannover.f4.trust.ifmapj.messages.SearchResult;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class PollRequestHandler
implements RequestHandler<PollRequest> {
    PollRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFqName("poll"));
        Requests.Helpers.addSessionId(ret, req);
        return ret;
    }

    @Override
    public Result fromElement(Element res) throws UnmarshalException, IfmapErrorResult {
        return this.parsePollResultElement(res);
    }

    private Result parsePollResultElement(Element res) throws UnmarshalException, IfmapErrorResult {
        Element content = Requests.Helpers.getResponseContentNoErrorCheck(res);
        ArrayList<SearchResult> sResults = new ArrayList<SearchResult>();
        ArrayList<IfmapErrorResult> errorResults = new ArrayList<IfmapErrorResult>();
        if (DomHelpers.elementMatches(content, "pollResult")) {
            List<Element> elementChildren = DomHelpers.getChildElements(content);
            if (elementChildren.size() == 0) {
                throw new UnmarshalException("No result elements in pollResult");
            }
            for (Element child : elementChildren) {
                String curName = null;
                SearchResult.Type curType = this.resultType(child);
                if (curType != null) {
                    SearchResult curSearchResult = Requests.Helpers.parseSearchResult(child, curType);
                    curName = curSearchResult.getName();
                    sResults.add(curSearchResult);
                } else {
                    IfmapErrorResult err = Requests.Helpers.parseErrorResult(child);
                    curName = err.getName();
                    errorResults.add(err);
                }
                if (curName != null) continue;
                throw new UnmarshalException("No name set for result in pollResult");
            }
        } else {
            if (DomHelpers.elementMatches(content, "endSessionResult")) {
                return new EndSessionException();
            }
            Requests.Helpers.checkForError(content);
            throw new UnmarshalException("Bad poll response: " + content.getLocalName());
        }
        return new PollResultImpl(sResults, errorResults);
    }

    private SearchResult.Type resultType(Element child) throws UnmarshalException {
        if (DomHelpers.elementMatches(child, "searchResult")) {
            return SearchResult.Type.searchResult;
        }
        if (DomHelpers.elementMatches(child, "updateResult")) {
            return SearchResult.Type.updateResult;
        }
        if (DomHelpers.elementMatches(child, "deleteResult")) {
            return SearchResult.Type.deleteResult;
        }
        if (DomHelpers.elementMatches(child, "notifyResult")) {
            return SearchResult.Type.notifyResult;
        }
        if (DomHelpers.elementMatches(child, "errorResult")) {
            return null;
        }
        throw new UnmarshalException("Unknown element in pollResult: " + child.getLocalName());
    }

    @Override
    public Class<PollRequest> handles() {
        return PollRequest.class;
    }
}

