/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.messages;

import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.messages.IdentifierHolder;
import de.hshannover.f4.trust.ifmapj.messages.MetadataHolder;
import de.hshannover.f4.trust.ifmapj.messages.MetadataLifetime;
import de.hshannover.f4.trust.ifmapj.messages.PublishDelete;
import de.hshannover.f4.trust.ifmapj.messages.PublishElement;
import de.hshannover.f4.trust.ifmapj.messages.PublishNotify;
import de.hshannover.f4.trust.ifmapj.messages.PublishRequest;
import de.hshannover.f4.trust.ifmapj.messages.PublishUpdate;
import de.hshannover.f4.trust.ifmapj.messages.Request;
import de.hshannover.f4.trust.ifmapj.messages.RequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.Result;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import util.DomHelpers;

class PublishRequestHandler
implements RequestHandler<PublishRequest> {
    PublishRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        PublishRequest pr = (PublishRequest)req;
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFqName("publish"));
        this.addPublishElements(pr, doc, ret);
        Requests.Helpers.addSessionId(ret, req);
        return ret;
    }

    private void addPublishElements(PublishRequest pr, Document doc, Element to) throws MarshalException {
        if (pr.getPublishElements().size() == 0) {
            throw new MarshalException("No publish elements");
        }
        for (PublishElement pubEl : pr.getPublishElements()) {
            Element el;
            if (pubEl instanceof PublishUpdate) {
                PublishUpdate pu = (PublishUpdate)pubEl;
                MetadataLifetime lifetime = MetadataLifetime.session;
                el = DomHelpers.createNonNsElement(doc, "update");
                if (pu.getLifeTime() != null) {
                    lifetime = pu.getLifeTime();
                }
                DomHelpers.addAttribute(el, "lifetime", lifetime.toString());
            } else if (pubEl instanceof PublishDelete) {
                PublishDelete pd = (PublishDelete)pubEl;
                el = DomHelpers.createNonNsElement(doc, "delete");
                if (pd.getFilter() != null) {
                    DomHelpers.addAttribute(el, "filter", pd.getFilter());
                }
                DomHelpers.addXmlNamespaceDeclarations(pd, el);
            } else if (pubEl instanceof PublishNotify) {
                el = DomHelpers.createNonNsElement(doc, "notify");
            } else {
                throw new MarshalException("Unknown PublishElement Implementation");
            }
            if (!(pubEl instanceof IdentifierHolder)) {
                throw new MarshalException("No IdentifierHoldingRequest?");
            }
            Requests.Helpers.addIdentifiers((IdentifierHolder)((Object)pubEl), doc, el);
            if (pubEl instanceof MetadataHolder) {
                this.addMetadataList((MetadataHolder)((Object)pubEl), doc, el);
            }
            to.appendChild(el);
        }
    }

    private void addMetadataList(MetadataHolder mh, Document doc, Element to) throws MarshalException {
        if (mh.getMetadata().size() == 0) {
            throw new MarshalException("No metadata to add");
        }
        Element mlist = DomHelpers.createNonNsElement(doc, "metadata");
        to.appendChild(mlist);
        for (Document md : mh.getMetadata()) {
            Node node = md.getFirstChild();
            if (node == null) {
                throw new MarshalException("Metadata has no root Element?");
            }
            if (!(node instanceof Element)) {
                throw new MarshalException("Metadata root element not Element?");
            }
            Element toClone = (Element)node;
            Element clone = (Element)toClone.cloneNode(true);
            doc.adoptNode(clone);
            mlist.appendChild(clone);
        }
    }

    @Override
    public Result fromElement(Element resp) throws UnmarshalException, IfmapErrorResult {
        Requests.Helpers.checkSimpleResult(resp, "publishReceived");
        return null;
    }

    @Override
    public Class<PublishRequest> handles() {
        return PublishRequest.class;
    }
}

