/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.messages;

import de.hshannover.f4.trust.ifmapj.binding.IfmapStrings;
import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorCode;
import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.identifier.Identifiers;
import de.hshannover.f4.trust.ifmapj.messages.DumpRequest;
import de.hshannover.f4.trust.ifmapj.messages.DumpRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.DumpRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.EndSessionRequest;
import de.hshannover.f4.trust.ifmapj.messages.EndSessionRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.EndSessionRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.IdentifierHolder;
import de.hshannover.f4.trust.ifmapj.messages.MetadataHolder;
import de.hshannover.f4.trust.ifmapj.messages.MetadataLifetime;
import de.hshannover.f4.trust.ifmapj.messages.NewSessionRequest;
import de.hshannover.f4.trust.ifmapj.messages.NewSessionRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.NewSessionRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.PollRequest;
import de.hshannover.f4.trust.ifmapj.messages.PollRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.PollRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.PublishDelete;
import de.hshannover.f4.trust.ifmapj.messages.PublishDeleteImpl;
import de.hshannover.f4.trust.ifmapj.messages.PublishElement;
import de.hshannover.f4.trust.ifmapj.messages.PublishNotify;
import de.hshannover.f4.trust.ifmapj.messages.PublishNotifyImpl;
import de.hshannover.f4.trust.ifmapj.messages.PublishRequest;
import de.hshannover.f4.trust.ifmapj.messages.PublishRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.PublishRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.PublishUpdate;
import de.hshannover.f4.trust.ifmapj.messages.PublishUpdateImpl;
import de.hshannover.f4.trust.ifmapj.messages.PurgePublisherRequest;
import de.hshannover.f4.trust.ifmapj.messages.PurgePublisherRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.PurgePublisherRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.RenewSessionRequest;
import de.hshannover.f4.trust.ifmapj.messages.RenewSessionRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.RenewSessionRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.Request;
import de.hshannover.f4.trust.ifmapj.messages.RequestFactory;
import de.hshannover.f4.trust.ifmapj.messages.RequestFactoryImpl;
import de.hshannover.f4.trust.ifmapj.messages.RequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.ResultItem;
import de.hshannover.f4.trust.ifmapj.messages.ResultItemImpl;
import de.hshannover.f4.trust.ifmapj.messages.SearchHolder;
import de.hshannover.f4.trust.ifmapj.messages.SearchHolderImpl;
import de.hshannover.f4.trust.ifmapj.messages.SearchRequest;
import de.hshannover.f4.trust.ifmapj.messages.SearchRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.SearchRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.SearchResult;
import de.hshannover.f4.trust.ifmapj.messages.SearchResultImpl;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeDelete;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeDeleteImpl;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeElement;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeRequest;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeRequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeRequestImpl;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeUpdate;
import de.hshannover.f4.trust.ifmapj.messages.SubscribeUpdateImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

public final class Requests {
    private static Map<Class<? extends Request>, RequestHandler<? extends Request>> sRequestHandlers;
    private static RequestFactory sRequestFactoryInstance;

    private Requests() {
    }

    private static void initializeDefaultHandlers() {
        sRequestHandlers = new HashMap<Class<? extends Request>, RequestHandler<? extends Request>>();
        Requests.registerRequestHandler(new NewSessionRequestHandler());
        Requests.registerRequestHandler(new EndSessionRequestHandler());
        Requests.registerRequestHandler(new PurgePublisherRequestHandler());
        Requests.registerRequestHandler(new RenewSessionRequestHandler());
        Requests.registerRequestHandler(new PollRequestHandler());
        Requests.registerRequestHandler(new PublishRequestHandler());
        Requests.registerRequestHandler(new SubscribeRequestHandler());
        Requests.registerRequestHandler(new SearchRequestHandler());
        Requests.registerRequestHandler(new DumpRequestHandler());
    }

    public static void registerRequestHandler(RequestHandler<? extends Request> rh) {
        if (rh == null) {
            throw new NullPointerException("rh is null");
        }
        if (rh.handles() == null) {
            throw new NullPointerException("rh.handles() returns null");
        }
        if (sRequestHandlers == null) {
            Requests.initializeDefaultHandlers();
        }
        if (sRequestHandlers.containsKey(rh.handles())) {
            throw new RuntimeException("RequestHandler already registered for " + rh.handles());
        }
        sRequestHandlers.put(rh.handles(), rh);
    }

    public static RequestHandler<? extends Request> getHandlerFor(Request req) {
        if (sRequestHandlers == null) {
            Requests.initializeDefaultHandlers();
        }
        for (Map.Entry<Class<? extends Request>, RequestHandler<? extends Request>> entry : sRequestHandlers.entrySet()) {
            if (!entry.getKey().isInstance(req)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Deprecated
    public static RequestFactory getRequestFactory() {
        if (sRequestFactoryInstance == null) {
            sRequestFactoryInstance = new RequestFactoryImpl();
        }
        return sRequestFactoryInstance;
    }

    public static PublishRequest createPublishReq() {
        return new PublishRequestImpl();
    }

    public static PublishRequest createPublishReq(PublishElement el) {
        if (el == null) {
            throw new NullPointerException("el is not allowed to be null");
        }
        PublishRequest ret = Requests.createPublishReq();
        ret.addPublishElement(el);
        return ret;
    }

    public static PublishRequest createPublishReq(List<PublishElement> list) {
        if (list == null) {
            throw new NullPointerException("list is not allowed to be null");
        }
        PublishRequest ret = Requests.createPublishReq();
        for (PublishElement el : list) {
            ret.addPublishElement(el);
        }
        return ret;
    }

    public static DumpRequest createDumpReq() {
        return new DumpRequestImpl();
    }

    public static NewSessionRequest createNewSessionReq() {
        return new NewSessionRequestImpl();
    }

    public static EndSessionRequest createEndSessionReq() {
        return new EndSessionRequestImpl();
    }

    public static RenewSessionRequest createRenewSessionReq() {
        return new RenewSessionRequestImpl();
    }

    public static PurgePublisherRequest createPurgePublisherReq() {
        return new PurgePublisherRequestImpl();
    }

    public static PollRequest createPollReq() {
        return new PollRequestImpl();
    }

    public static SubscribeRequest createSubscribeReq() {
        return new SubscribeRequestImpl();
    }

    public static SubscribeRequest createSubscribeReq(SubscribeElement el) {
        if (el == null) {
            throw new NullPointerException("el is not allowed to be null");
        }
        SubscribeRequest ret = Requests.createSubscribeReq();
        ret.addSubscribeElement(el);
        return ret;
    }

    public static SubscribeRequest createSubscribeReq(List<SubscribeElement> list) {
        if (list == null) {
            throw new NullPointerException("list is not allowed to be null");
        }
        SubscribeRequest ret = Requests.createSubscribeReq();
        for (SubscribeElement el : list) {
            ret.addSubscribeElement(el);
        }
        return ret;
    }

    public static SearchRequest createSearchReq() {
        return new SearchRequestImpl(new SearchHolderImpl());
    }

    public static SearchRequest createSearchReq(String matchLinks, Integer maxDepth, String termIdents, Integer maxSize, String resultFilter, Identifier start) {
        SearchRequest sr = Requests.createSearchReq();
        Requests.fillSearchHolder(sr, matchLinks, maxDepth, termIdents, maxSize, resultFilter, start);
        return sr;
    }

    private static void fillSearchHolder(SearchHolder holder, String matchLinks, Integer maxDepth, String termIdents, Integer maxSize, String resultFilter, Identifier start) {
        holder.setMatchLinksFilter(matchLinks);
        holder.setMaxDepth(maxDepth);
        holder.setTerminalIdentifierTypes(termIdents);
        holder.setMaxSize(maxSize);
        holder.setResultFilter(resultFilter);
        holder.setStartIdentifier(start);
    }

    public static PublishUpdate createPublishUpdate() {
        return new PublishUpdateImpl();
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Document md) {
        return Requests.createPublishUpdate(i1, md, MetadataLifetime.session);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Document md, MetadataLifetime lifetime) {
        return Requests.createPublishUpdate(i1, null, md, lifetime);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Identifier i2, Document md) {
        return Requests.createPublishUpdate(i1, i2, md, MetadataLifetime.session);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Identifier i2, Document md, MetadataLifetime lifetime) {
        if (md == null) {
            throw new NullPointerException("md not allowed to be null");
        }
        ArrayList<Document> list = new ArrayList<Document>(1);
        list.add(md);
        return Requests.createPublishUpdate(i1, i2, list, lifetime);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Collection<Document> mdlist, MetadataLifetime lifetime) {
        return Requests.createPublishUpdate(i1, null, mdlist, lifetime);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Collection<Document> mdlist) {
        return Requests.createPublishUpdate(i1, null, mdlist);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Identifier i2, Collection<Document> mdlist) {
        return Requests.createPublishUpdate(i1, i2, mdlist, MetadataLifetime.session);
    }

    public static PublishUpdate createPublishUpdate(Identifier i1, Identifier i2, Collection<Document> mdlist, MetadataLifetime lifetime) {
        if (mdlist == null) {
            throw new NullPointerException("mdlist not allowed to be null");
        }
        PublishUpdate pu = Requests.createPublishUpdate();
        Requests.fillMetadataHolder(pu, i1, i2, mdlist);
        pu.setLifeTime(lifetime);
        return pu;
    }

    public static PublishNotify createPublishNotify() {
        return new PublishNotifyImpl();
    }

    public static PublishNotify createPublishNotify(Identifier i1, Document md) {
        return Requests.createPublishNotify(i1, null, md);
    }

    public static PublishNotify createPublishNotify(Identifier i1, Collection<Document> mdlist) {
        return Requests.createPublishNotify(i1, null, mdlist);
    }

    public static PublishNotify createPublishNotify(Identifier i1, Identifier i2, Document md) {
        if (md == null) {
            throw new NullPointerException("md is null");
        }
        ArrayList<Document> mdlist = new ArrayList<Document>(1);
        mdlist.add(md);
        return Requests.createPublishNotify(i1, i2, mdlist);
    }

    public static PublishNotify createPublishNotify(Identifier i1, Identifier i2, Collection<Document> mdlist) {
        if (mdlist == null) {
            throw new NullPointerException("mdlist is null");
        }
        PublishNotify pn = Requests.createPublishNotify();
        Requests.fillMetadataHolder(pn, i1, i2, mdlist);
        return pn;
    }

    private static void fillMetadataHolder(MetadataHolder holder, Identifier i1, Identifier i2, Collection<Document> mdlist) {
        Requests.fillIdentifierHolder(holder, i1, i2);
        if (mdlist != null) {
            for (Document md : mdlist) {
                holder.addMetadata(md);
            }
        }
    }

    private static void fillIdentifierHolder(IdentifierHolder holder, Identifier i1, Identifier i2) {
        holder.setIdentifier1(i1);
        holder.setIdentifier2(i2);
    }

    public static PublishDelete createPublishDelete() {
        return new PublishDeleteImpl();
    }

    public static PublishDelete createPublishDelete(Identifier i1) {
        return Requests.createPublishDelete(i1, (String)null);
    }

    public static PublishDelete createPublishDelete(Identifier i1, Identifier i2) {
        return Requests.createPublishDelete(i1, i2, null);
    }

    public static PublishDelete createPublishDelete(Identifier i1, String filter) {
        return Requests.createPublishDelete(i1, null, filter);
    }

    public static PublishDelete createPublishDelete(Identifier i1, Identifier i2, String filter) {
        PublishDelete pd = Requests.createPublishDelete();
        Requests.fillIdentifierHolder(pd, i1, i2);
        pd.setFilter(filter);
        return pd;
    }

    public static SubscribeUpdate createSubscribeUpdate() {
        return new SubscribeUpdateImpl(new SearchHolderImpl());
    }

    public static SubscribeUpdate createSubscribeUpdate(String name, String matchLinks, Integer maxDepth, String termIdents, Integer maxSize, String resultFilter, Identifier start) {
        SubscribeUpdate su = Requests.createSubscribeUpdate();
        Requests.fillSearchHolder(su, matchLinks, maxDepth, termIdents, maxSize, resultFilter, start);
        su.setName(name);
        return su;
    }

    public static SubscribeDelete createSubscribeDelete() {
        return new SubscribeDeleteImpl();
    }

    public static SubscribeDelete createSubscribeDelete(String name) {
        SubscribeDelete sd = Requests.createSubscribeDelete();
        sd.setName(name);
        return sd;
    }

    public static final class Helpers {
        private Helpers() {
        }

        public static String baseNsUri() {
            return "http://www.trustedcomputinggroup.org/2010/IFMAP/2";
        }

        public static void addSearchInfo(SearchHolder searchInfo, Document doc, Element to) throws MarshalException {
            Identifier id = searchInfo.getStartIdentifier();
            String matchLinks = searchInfo.getMatchLinksFilter();
            String resultFilter = searchInfo.getResultFilter();
            Integer maxDepth = searchInfo.getMaxDepth();
            Integer maxSize = searchInfo.getMaxSize();
            String terminalIdentifiers = searchInfo.getTerminalIdentifierTypes();
            if (id == null) {
                throw new MarshalException("No start identifier");
            }
            Helpers.addIdentifier(id, doc, to);
            if (matchLinks != null) {
                DomHelpers.addAttribute(to, "match-links", matchLinks);
            }
            if (resultFilter != null) {
                DomHelpers.addAttribute(to, "result-filter", resultFilter);
            }
            if (terminalIdentifiers != null) {
                DomHelpers.addAttribute(to, "terminal-identifier-type", terminalIdentifiers);
            }
            if (maxDepth != null) {
                DomHelpers.addAttribute(to, "max-depth", maxDepth.toString());
            }
            if (maxSize != null) {
                DomHelpers.addAttribute(to, "max-size", maxSize.toString());
            }
            DomHelpers.addXmlNamespaceDeclarations(searchInfo, to);
        }

        public static void addIdentifiers(IdentifierHolder ih, Document doc, Element to) throws MarshalException {
            Identifier i1 = ih.getIdentifier1();
            Identifier i2 = ih.getIdentifier2();
            if (i1 == null && i2 == null) {
                throw new MarshalException("IdentifierHolder with no Identifiers");
            }
            if (i1 != null) {
                Helpers.addIdentifier(i1, doc, to);
            }
            if (i2 != null) {
                Helpers.addIdentifier(i2, doc, to);
            }
        }

        public static void addIdentifier(Identifier i, Document doc, Element to) throws MarshalException {
            to.appendChild(Identifiers.toElement(i, doc));
        }

        public static void addSessionId(Element el, Request r) throws MarshalException {
            if (r.getSessionId() == null || r.getSessionId().length() == 0) {
                throw new MarshalException("sessionId is null");
            }
            DomHelpers.addAttribute(el, "session-id", r.getSessionId());
        }

        public static SearchResult parseSearchResult(Element sres, SearchResult.Type type) throws UnmarshalException {
            ArrayList<ResultItem> ritems = new ArrayList<ResultItem>();
            String name = null;
            List<Element> elementChildren = DomHelpers.getChildElements(sres);
            if (elementChildren.size() == 0) {
                throw new UnmarshalException("searchResult with no resultItems");
            }
            for (Element child : elementChildren) {
                if (!DomHelpers.elementMatches(child, "resultItem")) {
                    throw new UnmarshalException("Found non resultItem element in SearchResult: " + child.getLocalName());
                }
                ritems.add(Helpers.parseResultItem(child));
            }
            name = sres.getAttribute("name");
            name = name != null && name.length() > 0 ? name : null;
            return new SearchResultImpl(ritems, name, type);
        }

        public static ResultItem parseResultItem(Element el) throws UnmarshalException {
            Identifier ident1 = null;
            Identifier ident2 = null;
            List<Document> mdlist = null;
            List<Element> elementChildren = DomHelpers.getChildElements(el);
            if (elementChildren.size() == 0) {
                throw new UnmarshalException("No elements in resultItem found");
            }
            if (elementChildren.size() > 3) {
                throw new UnmarshalException("Too many elements in resultItem element (" + elementChildren.size() + ")");
            }
            for (Element child : elementChildren) {
                Identifier tmp = Identifiers.tryFromElement(child);
                if (tmp == null && DomHelpers.elementMatches(child, "metadata")) {
                    if (mdlist != null) {
                        throw new UnmarshalException("Multiple metadata elements  in resultItem found");
                    }
                    mdlist = Helpers.parseMetadataList(child);
                } else if (tmp == null) {
                    throw new UnmarshalException("Unexpected element in searchResult: " + child.getLocalName());
                }
                if (tmp != null && ident1 == null) {
                    ident1 = tmp;
                    continue;
                }
                if (tmp != null && ident2 == null) {
                    ident2 = tmp;
                    continue;
                }
                if (tmp == null) continue;
                throw new UnmarshalException("Found > 2 identifiers in resultItem");
            }
            if (ident1 == null && ident2 == null) {
                throw new UnmarshalException("No identifier found in searchResult");
            }
            if (mdlist == null) {
                mdlist = new LinkedList<Document>();
            }
            return new ResultItemImpl(ident1, ident2, mdlist);
        }

        public static List<Document> parseMetadataList(Element el) throws UnmarshalException {
            ArrayList<Document> ret = new ArrayList<Document>();
            List<Element> elementChildren = DomHelpers.getChildElements(el);
            for (Element child : elementChildren) {
                ret.add(DomHelpers.deepCopy(child));
            }
            return ret;
        }

        public static IfmapErrorResult parseErrorResult(Element el) throws UnmarshalException {
            Element errStrElem = null;
            IfmapErrorCode errCode = null;
            String name = null;
            String errCodeStr = el.getAttribute("errorCode");
            errStrElem = DomHelpers.findElementInChildren(el, "errorString", IfmapStrings.NO_URI);
            String errStr = errStrElem == null ? "IfmapJ: errorString not set" : errStrElem.getTextContent();
            try {
                errCode = IfmapErrorCode.valueOf(errCodeStr);
            }
            catch (IllegalArgumentException e) {
                throw new UnmarshalException("Invalid errorCode received: " + errCodeStr);
            }
            if (el.getAttributeNode("name") != null) {
                name = el.getAttribute("name");
            }
            return new IfmapErrorResult(errCode, errStr, name);
        }

        public static void checkSimpleResult(Element el, String expected) throws UnmarshalException, IfmapErrorResult {
            Element content = Helpers.getResponseContentErrorCheck(el);
            if (!DomHelpers.elementMatches(content, expected)) {
                throw new UnmarshalException("Wrong Result. Expected " + expected + " got " + content.getLocalName());
            }
        }

        public static Element getResponseContentErrorCheck(Element response) throws UnmarshalException, IfmapErrorResult {
            Element content = Helpers.getResponseContentNoErrorCheck(response);
            Helpers.checkForError(content);
            return content;
        }

        public static Element getResponseContentNoErrorCheck(Element response) throws UnmarshalException, IfmapErrorResult {
            List<Element> children = DomHelpers.getChildElements(response);
            if (children.size() == 0) {
                throw new UnmarshalException("No element in response element found");
            }
            if (children.size() > 1) {
                throw new UnmarshalException("Too many elements in response element  found (" + children.size() + ")");
            }
            return children.get(0);
        }

        public static void checkForError(Element el) throws UnmarshalException, IfmapErrorResult {
            if (DomHelpers.elementMatches(el, "errorResult")) {
                throw Helpers.parseErrorResult(el);
            }
        }

        public static void checkRequestType(Request req, RequestHandler<? extends Request> rh) throws MarshalException {
            Class<? extends Request> clazz = rh.handles();
            if (!clazz.isInstance(req)) {
                throw new MarshalException("Handler for requests of type " + rh.handles() + " got request of type " + req.getClass());
            }
        }
    }
}

