/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.messages;

import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.exception.UnmarshalException;
import de.hshannover.f4.trust.ifmapj.messages.Request;
import de.hshannover.f4.trust.ifmapj.messages.RequestHandler;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.Result;
import de.hshannover.f4.trust.ifmapj.messages.SearchRequest;
import de.hshannover.f4.trust.ifmapj.messages.SearchResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class SearchRequestHandler
implements RequestHandler<SearchRequest> {
    SearchRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        SearchRequest sr = (SearchRequest)req;
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFqName("search"));
        Requests.Helpers.addSessionId(ret, req);
        Requests.Helpers.addSearchInfo(sr, doc, ret);
        return ret;
    }

    @Override
    public Result fromElement(Element resp) throws UnmarshalException, IfmapErrorResult {
        Element content = Requests.Helpers.getResponseContentErrorCheck(resp);
        SearchResult ret = Requests.Helpers.parseSearchResult(content, SearchResult.Type.searchResult);
        if (ret.getName() != null) {
            throw new UnmarshalException("Found name attribute in searchResult after normal search");
        }
        return ret;
    }

    @Override
    public Class<SearchRequest> handles() {
        return SearchRequest.class;
    }
}

