/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.messages;

import de.hshannover.f4.trust.ifmapj.messages.ResultItem;
import de.hshannover.f4.trust.ifmapj.messages.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SearchResultImpl
implements SearchResult {
    private final List<ResultItem> mResultItems;
    private final String mName;
    private final SearchResult.Type mType;

    SearchResultImpl(List<ResultItem> ritems, String name, SearchResult.Type type) {
        if (ritems == null) {
            throw new NullPointerException("ritems is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.mResultItems = new ArrayList<ResultItem>(ritems);
        this.mName = name;
        this.mType = type;
    }

    SearchResultImpl(List<ResultItem> ritems) {
        this(ritems, null, SearchResult.Type.searchResult);
    }

    @Override
    public List<ResultItem> getResultItems() {
        return Collections.unmodifiableList(this.mResultItems);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public SearchResult.Type getType() {
        return this.mType;
    }

    public String toString() {
        int i = 0;
        StringBuilder sb = new StringBuilder("sr{");
        if (this.mName != null) {
            sb.append(this.mName);
            sb.append(", ");
        }
        for (ResultItem ri : this.mResultItems) {
            sb.append(ri.toString());
            if (++i == this.mResultItems.size()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

