/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj.metadata;

import de.hshannover.f4.trust.ifmapj.log.IfmapJLog;
import de.hshannover.f4.trust.ifmapj.metadata.Metadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import util.CanonicalXML;

public class MetadataWrapper {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    public static final NamespaceContext DEFAULT_NAMESPACE_CONTEXT = new NamespaceContext(){

        public Iterator getPrefixes(String namespaceURI) {
            return Arrays.asList("meta", "ifmap").iterator();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI.equals("http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2")) {
                return "meta";
            }
            if (namespaceURI.equals("http://www.trustedcomputinggroup.org/2010/IFMAP/2")) {
                return "ifmap";
            }
            return null;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("meta")) {
                return "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2";
            }
            if (prefix.equals("ifmap")) {
                return "http://www.trustedcomputinggroup.org/2010/IFMAP/2";
            }
            return "";
        }
    };

    public static Metadata metadata(Document document) {
        try {
            Transformer printFormatTransformer = TRANSFORMER_FACTORY.newTransformer();
            printFormatTransformer.setOutputProperty("omit-xml-declaration", "yes");
            printFormatTransformer.setOutputProperty("method", "xml");
            printFormatTransformer.setOutputProperty("indent", "yes");
            printFormatTransformer.setOutputProperty("encoding", "UTF-8");
            printFormatTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            Transformer equalsTransformer = TRANSFORMER_FACTORY.newTransformer();
            equalsTransformer.setOutputProperty("omit-xml-declaration", "yes");
            equalsTransformer.setOutputProperty("indent", "no");
            equalsTransformer.setOutputProperty("method", "xml");
            XPath xPath = XPATH_FACTORY.newXPath();
            return new MetadataWrapperImpl(document, xPath, printFormatTransformer, DEFAULT_NAMESPACE_CONTEXT, equalsTransformer);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MetadataWrapperImpl
    implements Metadata {
        final Document mDocument;
        final XPath mXpath;
        final Transformer mPrintTransformer;
        final Transformer mEqualsTransformer;

        public MetadataWrapperImpl(Document document, XPath xpath, Transformer printFormatTransformer, NamespaceContext namespaceContext, Transformer equalsTransformer) {
            this.mDocument = document;
            this.mXpath = xpath;
            this.mPrintTransformer = printFormatTransformer;
            this.mXpath.setNamespaceContext(namespaceContext);
            this.mEqualsTransformer = equalsTransformer;
        }

        private String getValueFromExpression(String expression, Document doc) {
            try {
                return this.mXpath.evaluate(expression, this.mDocument.getDocumentElement());
            }
            catch (XPathExpressionException e) {
                IfmapJLog.error("could not evaluate '" + expression + "' on '" + this.mDocument + "'");
                return null;
            }
        }

        @Override
        public String getPublisherId() {
            return this.getValueFromExpression("/*/@ifmap-publisher-id", this.mDocument);
        }

        @Override
        public String getPublishTimestamp() {
            return this.getValueFromExpression("/*/@ifmap-timestamp", this.mDocument);
        }

        @Override
        public double getPublishTimestampFraction() {
            String fractionString = this.getValueFromExpression("/*/@ifmap-timestamp-fraction", this.mDocument);
            try {
                return Double.parseDouble(fractionString);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @Override
        public String getTypename() {
            return this.getValueFromExpression("name(/*)", this.mDocument);
        }

        @Override
        public String getLocalname() {
            return this.getValueFromExpression("local-name(/*)", this.mDocument);
        }

        @Override
        public String getCardinality() {
            return this.getValueFromExpression("/*/@ifmap-cardinality", this.mDocument);
        }

        @Override
        public boolean isSingleValue() {
            return this.getCardinality().equals("singleValue");
        }

        @Override
        public boolean isMultiValue() {
            return this.getCardinality().equals("multiValue");
        }

        @Override
        public String getValueForXpathExpression(String xPathExpression) {
            return this.getValueFromExpression(xPathExpression, this.mDocument);
        }

        @Override
        public String getValueForXpathExpressionOrElse(String xPathExpression, String defaultValue) {
            String result = this.getValueForXpathExpression(xPathExpression);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }

        @Override
        public String toFormattedString() {
            StringWriter writer = new StringWriter();
            try {
                this.mPrintTransformer.transform(new DOMSource(this.mDocument), new StreamResult(writer));
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            return writer.toString();
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) {
            this.mXpath.setNamespaceContext(context);
        }

        private String toCanonicalXml() {
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                DOMSource domSource = new DOMSource(this.mDocument.getFirstChild());
                ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(byteArrayOutput);
                this.mEqualsTransformer.transform(domSource, result);
                ByteArrayInputStream byteArrayInput = new ByteArrayInputStream(byteArrayOutput.toByteArray());
                InputSource input = new InputSource(byteArrayInput);
                CanonicalXML canonicalXml = new CanonicalXML();
                return canonicalXml.toCanonicalXml2(reader, input, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.toCanonicalXml().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetadataWrapperImpl other = (MetadataWrapperImpl)obj;
            return other.toCanonicalXml().equals(this.toCanonicalXml());
        }
    }
}

