/*
 * Decompiled with CFR 0.152.
 */
package de.hshannover.f4.trust.ifmapj21;

import de.hshannover.f4.trust.ifmapj.IfmapJ;
import de.hshannover.f4.trust.ifmapj.channel.SSRC;
import de.hshannover.f4.trust.ifmapj.exception.IfmapErrorResult;
import de.hshannover.f4.trust.ifmapj.exception.IfmapException;
import de.hshannover.f4.trust.ifmapj.identifier.Device;
import de.hshannover.f4.trust.ifmapj.identifier.Identifier;
import de.hshannover.f4.trust.ifmapj.log.IfmapJLog;
import de.hshannover.f4.trust.ifmapj.messages.MetadataLifetime;
import de.hshannover.f4.trust.ifmapj.messages.PublishDelete;
import de.hshannover.f4.trust.ifmapj.messages.PublishRequest;
import de.hshannover.f4.trust.ifmapj.messages.PublishUpdate;
import de.hshannover.f4.trust.ifmapj.messages.Requests;
import de.hshannover.f4.trust.ifmapj.messages.ResultItem;
import de.hshannover.f4.trust.ifmapj.messages.SearchRequest;
import de.hshannover.f4.trust.ifmapj.messages.SearchResult;
import de.hshannover.f4.trust.ifmapj.metadata.StandardIfmapMetadataFactory;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import util.DateHelpers;

public final class ClockSkewDetector {
    private final SSRC mSsrc;
    private Long mClockSkew;
    private Calendar mLastTimeSynchronization;
    private final Device mDev;
    private StandardIfmapMetadataFactory mMetadataFac;

    public static ClockSkewDetector newInstance(SSRC ssrc, Device dev) {
        return new ClockSkewDetector(ssrc, dev);
    }

    private ClockSkewDetector(SSRC ssrc, Device dev) {
        if (ssrc == null) {
            throw new NullPointerException();
        }
        if (dev == null) {
            throw new NullPointerException();
        }
        this.mSsrc = ssrc;
        this.mDev = dev;
        this.mMetadataFac = IfmapJ.createStandardMetadataFactory();
    }

    public long performClockSynchronization() throws IfmapErrorResult, IfmapException {
        return this.performClockSkewDetection(null);
    }

    public long performClockSkewDetection(Calendar clientTime) throws IfmapErrorResult, IfmapException {
        this.publishTime(clientTime);
        Element time = this.searchTime();
        this.deleteTimes();
        this.mClockSkew = this.calculateTimeDiff(time);
        this.mLastTimeSynchronization = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return this.mClockSkew;
    }

    private long calculateTimeDiff(Element time) {
        try {
            String ifmapTs = time.getAttribute("ifmap-timestamp");
            String curTs = time.getAttribute("current-timestamp");
            Calendar ifmapTime = DateHelpers.getTimeFromIso8601String(ifmapTs);
            Calendar curTime = DateHelpers.getTimeFromIso8601String(curTs);
            return ifmapTime.getTimeInMillis() - curTime.getTimeInMillis();
        }
        catch (DatatypeConfigurationException e) {
            IfmapJLog.warn("time sync: could not convert times: " + e.getMessage());
            return 0L;
        }
    }

    public boolean getClockSynchronized() {
        return this.mClockSkew != null;
    }

    public long getClockSkewMilliseconds() {
        return this.mClockSkew;
    }

    public Integer getClockSkewSeconds() {
        return (int)Math.round(this.mClockSkew.doubleValue() / 1000.0);
    }

    public Calendar getClockOfServer() {
        Calendar retCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        retCal.add(14, this.mClockSkew.intValue());
        return retCal;
    }

    public Calendar getClockLastSynchronization() {
        if (this.getClockSynchronized()) {
            return (Calendar)this.mLastTimeSynchronization.clone();
        }
        return null;
    }

    private void publishTime(Calendar clientTime) throws IfmapErrorResult, IfmapException {
        String date = DateHelpers.getUtcTimeAsIso8601(clientTime);
        Document timeMd = this.mMetadataFac.createClientTime(date);
        PublishUpdate pu = Requests.createPublishUpdate((Identifier)this.mDev, timeMd, MetadataLifetime.session);
        PublishRequest pr = Requests.createPublishReq(pu);
        this.mSsrc.publish(pr);
    }

    private Element searchTime() throws IfmapErrorResult, IfmapException {
        String resultFilter = "op-meta:client-time[@ifmap-publisher-id = \"" + this.mSsrc.getPublisherId() + "\"]";
        SearchRequest sr = Requests.createSearchReq(null, 0, null, null, resultFilter, this.mDev);
        sr.addNamespaceDeclaration("op-meta", "http://www.trustedcomputinggroup.org/2012/IFMAP-OPERATIONAL-METADATA/1");
        SearchResult res = this.mSsrc.search(sr);
        List<ResultItem> items = res.getResultItems();
        if (items.size() > 1) {
            IfmapJLog.warn("time sync: weird result item count: " + items.size());
        }
        if (items.size() == 0) {
            throw new IfmapException("time sync", "No ResultItems for search!");
        }
        ResultItem ri = items.get(0);
        List<Document> mlist = ri.getMetadata();
        if (mlist.size() > 1) {
            IfmapJLog.warn("time sync: multiple client-time elements: " + mlist.size());
        }
        if (mlist.size() == 0) {
            throw new IfmapException("time sync", "No client-time metadata!");
        }
        Document clientTime = mlist.get(mlist.size() - 1);
        Node node = clientTime.getFirstChild();
        if (node.getNodeType() != 1) {
            throw new IfmapException("time sync", "Metadata is not element");
        }
        return (Element)node;
    }

    private void deleteTimes() throws IfmapErrorResult, IfmapException {
        String filter = "op-meta:client-time[@ifmap-publisher-id = \"" + this.mSsrc.getPublisherId() + "\"]";
        PublishDelete pd = Requests.createPublishDelete((Identifier)this.mDev, filter);
        pd.addNamespaceDeclaration("op-meta", "http://www.trustedcomputinggroup.org/2012/IFMAP-OPERATIONAL-METADATA/1");
        PublishRequest pr = Requests.createPublishReq(pd);
        this.mSsrc.publish(pr);
    }
}

