/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public final class DateHelpers {
    private DateHelpers() {
    }

    public static String getUtcTimeAsIso8601() {
        return DateHelpers.getUtcTimeAsIso8601(null);
    }

    public static String getUtcTimeAsIso8601(Calendar cal) {
        try {
            if (cal == null) {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar(TimeZone.getTimeZone("UTC"))).toXMLFormat().replaceAll("\\.[0-9]{3}", "");
            }
            GregorianCalendar suppliedDateCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            suppliedDateCalendar.setTimeInMillis(cal.getTimeInMillis());
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(suppliedDateCalendar).toXMLFormat().replaceAll("\\.[0-9]{3}", "");
        }
        catch (DatatypeConfigurationException e) {
            SimpleDateFormat xmlDateUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            xmlDateUtc.setTimeZone(TimeZone.getTimeZone("UTC"));
            return xmlDateUtc.format(Calendar.getInstance());
        }
    }

    public static Calendar getTimeFromIso8601String(String isoDateStr) throws DatatypeConfigurationException {
        Calendar retCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        retCal.setTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(isoDateStr).toGregorianCalendar().getTime());
        return retCal;
    }
}

