/*
 * Decompiled with CFR 0.152.
 */
package util;

import de.hshannover.f4.trust.ifmapj.binding.IfmapStrings;
import de.hshannover.f4.trust.ifmapj.exception.MarshalException;
import de.hshannover.f4.trust.ifmapj.log.IfmapJLog;
import de.hshannover.f4.trust.ifmapj.messages.NamespaceDeclarationHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import util.CanonicalXML;
import util.Pair;

public final class DomHelpers {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final TransformerFactory TRANSFORMER_FACTORY;

    private DomHelpers() {
    }

    public static DocumentBuilder newDocumentBuilder() {
        try {
            return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            IfmapJLog.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Element createNonNsElement(Document doc, String name) {
        return doc.createElementNS(null, name);
    }

    public static void addAttribute(Element el, String name, String val) {
        el.setAttributeNS(null, name, val);
    }

    public static void addXmlNamespaceDeclarations(NamespaceDeclarationHolder nsh, Element to) {
        for (Pair<String, String> nsDecl : nsh.getNamespaceDeclarations()) {
            String name = "xmlns";
            if (((String)nsDecl.mFirst).length() > 0) {
                name = name + ":" + (String)nsDecl.mFirst;
            }
            String value = (String)nsDecl.mSecond;
            to.setAttributeNS("http://www.w3.org/2000/xmlns/", name, value);
        }
    }

    public static String makeRequestFqName(String name) {
        return "ifmap:" + name;
    }

    public static boolean elementMatches(Element el, String elname) {
        return DomHelpers.elementMatches(el, elname, IfmapStrings.NO_URI);
    }

    public static boolean elementMatches(Element e, String name, String uri) {
        return name.equals(e.getLocalName()) && (uri == null && e.getNamespaceURI() == null || uri != null && uri.equals(e.getNamespaceURI()));
    }

    public static List<Element> getChildElements(Element e) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            ret.add((Element)child);
        }
        return ret;
    }

    public static Element findElementInChildren(Node node, String name, String uri) {
        NodeList children = node.getChildNodes();
        Element ret = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !DomHelpers.elementMatches((Element)n, name, uri)) continue;
            ret = (Element)n;
            break;
        }
        return ret;
    }

    public static Document deepCopy(Element child) {
        Document mdDoc = DOCUMENT_BUILDER.newDocument();
        Element el = (Element)mdDoc.importNode(child, true);
        mdDoc.appendChild(el);
        return mdDoc;
    }

    public static InputStream toInputStream(Document doc) throws MarshalException {
        Transformer trans;
        try {
            trans = TRANSFORMER_FACTORY.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        byte[] marshalled = null;
        doc.setXmlStandalone(true);
        DOMSource source = new DOMSource(doc);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        try {
            baos.flush();
        }
        catch (IOException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        marshalled = baos.toByteArray();
        return new ByteArrayInputStream(marshalled);
    }

    public static String prepareExtendedIdentifier(Document doc) throws MarshalException {
        Transformer tf = null;
        String res = null;
        try {
            tf = TRANSFORMER_FACTORY.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        DomHelpers.fixupNamespace(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(doc.getFirstChild());
        StreamResult result = new StreamResult(baos);
        tf.setOutputProperty("omit-xml-declaration", "yes");
        tf.setOutputProperty("indent", "no");
        tf.setOutputProperty("method", "xml");
        try {
            tf.transform(domSource, result);
        }
        catch (TransformerException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputSource inputSource = new InputSource(bais);
        CanonicalXML cxml = new CanonicalXML();
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        try {
            res = cxml.toCanonicalXml2(reader, inputSource, true);
        }
        catch (Exception e) {
            IfmapJLog.error("Oh oh.... [" + e.getMessage() + "]");
            throw new MarshalException(e.getMessage());
        }
        return DomHelpers.escapeXml(res);
    }

    private static String escapeXml(String input) {
        String ret = input;
        String[] unwanted = new String[]{"&", "<", ">", "\"", "'"};
        String[] replaceBy = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};
        for (int i = 0; i < unwanted.length; ++i) {
            ret = ret.replace(unwanted[i], replaceBy[i]);
        }
        return ret;
    }

    private static void fixupNamespace(Document doc) throws MarshalException {
        Node n = doc.getFirstChild();
        if (n.getNodeType() != 1) {
            throw new RuntimeException("No element");
        }
        Element el = (Element)n;
        String prefix = el.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            el.setPrefix(null);
        } else {
            prefix = "";
        }
        DomHelpers.dropNamespaceDecls(el);
        DomHelpers.removePrefixFromChildren(el, prefix);
    }

    private static void dropNamespaceDecls(Element el) {
        NamedNodeMap nnm = el.getAttributes();
        ArrayList<Attr> toDrop = new ArrayList<Attr>();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            toDrop.add(attr);
        }
        for (Attr attr : toDrop) {
            nnm.removeNamedItemNS(attr.getNamespaceURI(), attr.getLocalName());
        }
    }

    private static void removePrefixFromChildren(Element el, String prefix) throws MarshalException {
        NodeList nl = el.getChildNodes();
        String localPrefix = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            localPrefix = n.getPrefix();
            if (localPrefix != null && localPrefix.length() > 0) {
                if (!localPrefix.equals(prefix)) {
                    IfmapJLog.warn("Extended Identifier: Multiple namespaces in extended identifer used.IfmapJ thinks this is not a wise idea. Sorry!");
                    throw new MarshalException("Extended Identifier: Multiple namespaces in extended identifer used.IfmapJ thinks this is not a wise idea. Sorry!");
                }
                n.setPrefix(null);
            }
            DomHelpers.removePrefixFromChildren((Element)n, prefix);
            DomHelpers.dropNamespaceDecls((Element)n);
        }
    }

    public static Document toDocument(InputStream is) throws MarshalException {
        try {
            return DomHelpers.newDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            IfmapJLog.error(e.getMessage());
            throw new MarshalException(e.getMessage());
        }
        catch (IOException e) {
            IfmapJLog.error(e.getMessage());
            throw new MarshalException(e.getMessage());
        }
    }

    public static Document toDocument(String s, Charset c) throws MarshalException {
        byte[] bytes = c == null ? s.getBytes() : s.getBytes(c);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return DomHelpers.toDocument(bais);
    }

    public static boolean compare(Document d1, Document d2) throws MarshalException {
        d1.normalize();
        d2.normalize();
        return d1.isEqualNode(d2);
    }

    static {
        TRANSFORMER_FACTORY = TransformerFactory.newInstance();
        DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        DOCUMENT_BUILDER = DomHelpers.newDocumentBuilder();
    }
}

