/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import util.Base64;
import util.MD5Provider;

public final class StringHelpers {
    private StringHelpers() {
    }

    public static int getStringCharCount(String string, char pattern) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != pattern) continue;
            ++count;
        }
        return count;
    }

    public static String fromByte(byte[] value) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            b.append(String.format("%02x%s", value[i], i < value.length - 1 ? ":" : ""));
        }
        return b.toString();
    }

    public static String getRandomString(int length) {
        byte[] aesKey = new byte[length];
        new SecureRandom().nextBytes(aesKey);
        try {
            return MD5Provider.getMd5(new String(aesKey));
        }
        catch (NoSuchAlgorithmException e) {
            return Base64.encodeToString(aesKey, true);
        }
    }
}

