/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeList
implements Iterable<Edge> {
    private Edge[] list;
    private int size;

    public EdgeList() {
        this(10);
    }

    public EdgeList(int n) {
        this.list = new Edge[n];
        this.size = 0;
    }

    public EdgeList(EdgeList edges) {
        this(edges.size);
        this.addEdgeList(edges);
    }

    public EdgeList(Edge edge) {
        this.list = new Edge[1];
        this.list[0] = edge;
        this.size = 0;
    }

    private void allocate(int minSize) {
        int oldSize = this.list.length;
        if (minSize > oldSize) {
            Edge[] oldList = this.list;
            int newSize = oldSize * 3 / 2 + 1;
            if (newSize < minSize) {
                newSize = minSize;
            }
            this.list = new Edge[newSize];
            System.arraycopy(oldList, 0, this.list, 0, oldSize);
        }
    }

    public void addEdgeList(EdgeList edges) {
        int edgesSize = edges.size;
        this.allocate(this.size + edgesSize);
        System.arraycopy(edges.list, 0, this.list, this.size, edgesSize);
        this.size += edgesSize;
    }

    public void addEdge(Edge e) {
        this.allocate(this.size + 1);
        this.list[this.size++] = e;
    }

    public boolean removeEdge(Edge edge) {
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (!e.equals(edge)) continue;
            this.removeEdge(i);
            return true;
        }
        return false;
    }

    protected void removeEdge(int index) {
        this.list[index] = this.list[--this.size];
        this.list[this.size] = null;
    }

    public Edge edgeAt(int i) {
        return this.list[i];
    }

    public int size() {
        return this.size;
    }

    public EdgeList sort() {
        EdgeList sorted = new EdgeList(this);
        Arrays.sort(sorted.list, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return e1.getDepends().max() - e2.getDepends().max();
            }
        });
        return sorted;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new EdgeIterator();
    }

    private EdgeList findEdges(Role role, Individual from, Node to) {
        EdgeList result = new EdgeList();
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            result.addEdge(e);
        }
        return result;
    }

    public EdgeList getEdgesFromTo(Individual from, Node to) {
        return this.findEdges(null, from, to);
    }

    public EdgeList getEdgesFrom(Individual from) {
        return this.findEdges(null, from, null);
    }

    public EdgeList getEdgesTo(Node to) {
        return this.findEdges(null, null, to);
    }

    public EdgeList getEdgesTo(Role r, Node to) {
        return this.findEdges(r, null, to);
    }

    public EdgeList getEdgesFrom(Individual from, Role r) {
        return this.findEdges(r, from, null);
    }

    public EdgeList getEdges(Role role) {
        EdgeList result = new EdgeList();
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (!e.getRole().isSubRoleOf(role)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public Set<Role> getRoles() {
        HashSet<Role> result = new HashSet<Role>();
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            result.add(e.getRole());
        }
        return result;
    }

    public Set<Node> getNeighbors(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            result.add(e.getNeighbor(node));
        }
        return result;
    }

    public Set<Node> getFilteredNeighbors(Individual node, ATermAppl c) {
        HashSet<Node> result = new HashSet<Node>();
        String lang = null;
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            Node neighbor = edge.getNeighbor(node);
            if (!ATermUtils.isTop(c) && !neighbor.hasType((ATerm)c)) continue;
            if (neighbor instanceof Literal) {
                Literal lit = (Literal)neighbor;
                if (lang == null) {
                    lang = lit.getLang();
                    result.add(neighbor);
                    continue;
                }
                if (!lang.equals(lit.getLang())) continue;
                result.add(neighbor);
                continue;
            }
            result.add(neighbor);
        }
        return result;
    }

    public boolean hasEdgeFrom(Individual from) {
        return this.hasEdge(from, null, null);
    }

    public boolean hasEdgeFrom(Individual from, Role role) {
        return this.hasEdge(from, role, null);
    }

    public boolean hasEdgeTo(Node to) {
        return this.hasEdge(null, null, to);
    }

    public boolean hasEdgeTo(Role role, Node to) {
        return this.hasEdge(null, role, to);
    }

    public boolean hasEdge(Role role) {
        return this.hasEdge(null, role, null);
    }

    public boolean hasEdge(Individual from, Role role, Node to) {
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactEdge(Individual from, Role role, Node to) {
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().equals(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(Edge e) {
        return this.hasEdge(e.getFrom(), e.getRole(), e.getTo());
    }

    public Edge getExactEdge(Individual from, Role role, Node to) {
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().equals(role) || to != null && !to.equals(e.getTo())) continue;
            return e;
        }
        return null;
    }

    public DependencySet getDepends(boolean doExplanation) {
        DependencySet ds = DependencySet.INDEPENDENT;
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            ds = ds.union(e.getDepends(), doExplanation);
        }
        return ds;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append(this.list[0]);
        for (int i = 1; i < this.size; ++i) {
            b.append(", ");
            b.append(this.list[i]);
        }
        b.append(']');
        return b.toString();
    }

    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            Edge e = this.list[i];
            if (e.getDepends().getBranch() == DependencySet.NO_BRANCH) continue;
            this.removeEdge(i--);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EdgeIterator
    implements Iterator<Edge> {
        private int curr = 0;

        @Override
        public boolean hasNext() {
            return this.curr != EdgeList.this.size;
        }

        @Override
        public Edge next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return EdgeList.this.list[this.curr++];
        }

        @Override
        public void remove() {
            EdgeList.this.removeEdge(--this.curr);
        }
    }
}

