/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.blocking.BlockingFactory;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.cache.CacheSafety;
import org.mindswap.pellet.tableau.cache.CacheSafetyFactory;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptySRIQStrategy
extends CompletionStrategy {
    private LinkedList<Individual> mayNeedExpanding;
    private List<List<Individual>> mnx;
    private Map<Individual, ATermAppl> cachedNodes;
    private CacheSafety cacheSafety;

    public EmptySRIQStrategy(ABox abox) {
        super(abox);
    }

    @Override
    public void initialize(Expressivity expressivity) {
        this.mergeList = new ArrayList();
        this.cachedNodes = new HashMap<Individual, ATermAppl>();
        this.mnx = new ArrayList<List<Individual>>();
        this.mnx.add(null);
        assert (this.abox.size() == 1) : "This strategy can only be used with originally empty ABoxes";
        this.blocking = BlockingFactory.createBlocking(expressivity);
        Individual root = this.abox.getIndIterator().next();
        this.applyUniversalRestrictions(root);
        this.selfRule.apply(root);
        this.mayNeedExpanding = new LinkedList();
        this.mayNeedExpanding.add(root);
        this.abox.setBranch(1);
        this.abox.stats.treeDepth = 1;
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    @Override
    public void complete(Expressivity expr) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("************  " + EmptySRIQStrategy.class.getName() + "  ************");
        }
        if (this.abox.getNodes().isEmpty()) {
            this.abox.setComplete(true);
            return;
        }
        if (this.abox.getNodes().size() > 1) {
            throw new RuntimeException("This strategy can only be used with an ABox that has a single individual.");
        }
        this.cacheSafety = this.abox.getCache().getSafety().canSupport(expr) ? this.abox.getCache().getSafety() : CacheSafetyFactory.createCacheSafety(expr);
        this.initialize(expr);
        while (!this.abox.isComplete() && !this.abox.isClosed()) {
            Individual x = this.getNextIndividual();
            if (x == null) {
                this.abox.setComplete(true);
                break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting with node " + x);
                this.abox.printTree();
                this.abox.validate();
            }
            this.expand(x);
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (!expr.hasInverse() || !this.parentNeedsExpanding(x)) continue;
            this.mayNeedExpanding.removeAll(this.getDescendants(x.getParent()));
            this.mayNeedExpanding.addFirst(x.getParent());
        }
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        if (PelletOptions.USE_ADVANCED_CACHING && !this.abox.isClosed()) {
            IndividualIterator i = new IndividualIterator(this.abox);
            while (i.hasNext()) {
                Individual ind = (Individual)i.next();
                ATermAppl c = this.cachedNodes.get(ind);
                if (c == null) continue;
                this.addCacheSat(c);
            }
        }
    }

    private List<Individual> getDescendants(Individual ind) {
        ArrayList<Individual> descendants = new ArrayList<Individual>();
        this.getDescendants(ind, descendants);
        return descendants;
    }

    private void getDescendants(Individual ind, List<Individual> descendants) {
        descendants.add(ind);
        for (Edge edge : ind.getOutEdges()) {
            if (!edge.getTo().isIndividual() || edge.getTo().equals(ind)) continue;
            this.getDescendants((Individual)edge.getTo(), descendants);
        }
    }

    private void addCacheSat(ATermAppl c) {
        if (!this.abox.getCache().putSat(c, true)) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("+++ Cache sat concept " + c);
        }
        if (ATermUtils.isAnd(c)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                this.addCacheSat((ATermAppl)list.getFirst());
                list = list.getNext();
            }
        }
    }

    private Individual getNextIndividual() {
        if (this.mayNeedExpanding.isEmpty()) {
            return null;
        }
        return this.mayNeedExpanding.get(0);
    }

    private boolean parentNeedsExpanding(Individual x) {
        if (x.isRoot()) {
            return false;
        }
        Individual parent = x.getParent();
        return parent.canApply(0) || parent.canApply(1) || parent.canApply(2) || parent.canApply(4) || parent.canApply(5);
    }

    private void expand(Individual x) {
        this.checkTimer();
        if (!this.abox.doExplanation() && PelletOptions.USE_ADVANCED_CACHING) {
            Timer t = this.abox.getKB().timers.startTimer("cache");
            Bool cachedSat = this.isCachedSat(x);
            t.stop();
            if (cachedSat.isKnown()) {
                if (cachedSat.isTrue()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Stop cached " + x);
                    }
                    this.mayNeedExpanding.remove(0);
                } else {
                    DependencySet ds = DependencySet.EMPTY;
                    for (ATermAppl c : x.getTypes()) {
                        ds = ds.union(x.getDepends((ATerm)c), this.abox.doExplanation());
                    }
                    this.abox.setClash(Clash.atomic(x, ds));
                }
                return;
            }
        }
        do {
            if (this.blocking.isDirectlyBlocked(x)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Stop blocked " + x);
                }
                this.mayNeedExpanding.remove(0);
                return;
            }
            this.unfoldingRule.apply(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.disjunctionRule.apply(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            if (this.blocking.isDynamic() && this.blocking.isDirectlyBlocked(x)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Stop blocked " + x);
                }
                this.mayNeedExpanding.remove(0);
                return;
            }
            this.someValuesRule.apply(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.minRule.apply(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            this.chooseRule.apply(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.maxRule.apply(x);
            if (!this.abox.isClosed()) continue;
            return;
        } while (x.canApply(0) || x.canApply(1) || x.canApply(2) || x.canApply(4));
        this.mayNeedExpanding.remove(0);
        EdgeList sortedSuccessors = x.getOutEdges().sort();
        if (PelletOptions.SEARCH_TYPE) {
            for (Edge edge : sortedSuccessors) {
                Node succ = edge.getTo();
                if (succ.isLiteral() || succ.equals(x)) continue;
                this.mayNeedExpanding.add((Individual)succ);
            }
        } else {
            for (int i = sortedSuccessors.size() - 1; i >= 0; --i) {
                Edge edge = sortedSuccessors.edgeAt(i);
                Node succ = edge.getTo();
                if (succ.isLiteral() || succ.equals(x)) continue;
                this.mayNeedExpanding.add((Individual)succ);
            }
        }
    }

    private ATermAppl createConcept(Individual x) {
        int count = 0;
        ATermAppl[] terms = new ATermAppl[x.getTypes().size()];
        for (int t = 0; t < 7; ++t) {
            if (t == 6) continue;
            for (ATermAppl c : x.getTypes(t)) {
                if (c.equals(ATermUtils.TOP)) continue;
                terms[count++] = c;
            }
        }
        switch (count) {
            case 0: {
                return ATermUtils.TOP;
            }
            case 1: {
                return terms[0];
            }
        }
        return ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])terms, count));
    }

    private Bool isCachedSat(Individual x) {
        if (x.isRoot()) {
            return Bool.UNKNOWN;
        }
        ATermAppl c = this.createConcept(x);
        Bool sat = this.isCachedSat(c);
        if (sat.isUnknown()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("??? Cache miss for " + c);
            }
            this.cachedNodes.put(x, c);
        } else if (!this.cacheSafety.isSafe(c, x)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("*** Cache unsafe for " + c);
            }
            sat = Bool.UNKNOWN;
        } else if (log.isLoggable(Level.FINER)) {
            log.finer("*** Cache hit for " + c + " sat = " + sat);
        }
        return sat;
    }

    private Bool isCachedSat(ATermAppl c) {
        Bool sat = this.abox.getCachedSat(c);
        if (sat.isKnown() || !ATermUtils.isAnd(c)) {
            return sat;
        }
        sat = null;
        ATermList list = (ATermList)c.getArgument(0);
        CachedNode cached1 = null;
        CachedNode cached2 = null;
        while (!list.isEmpty()) {
            ATermAppl d = (ATermAppl)list.getFirst();
            CachedNode node = this.abox.getCached(d);
            if (node == null || !node.isComplete()) {
                sat = Bool.UNKNOWN;
                break;
            }
            if (node.isBottom()) {
                sat = Bool.FALSE;
                break;
            }
            if (!node.isTop()) {
                if (cached1 == null) {
                    cached1 = node;
                } else if (cached2 == null) {
                    cached2 = node;
                } else {
                    sat = Bool.UNKNOWN;
                    break;
                }
            }
            list = list.getNext();
        }
        if (sat == null) {
            sat = cached2 == null ? Bool.TRUE : this.abox.getCache().isMergable(this.abox.getKB(), cached1, cached2);
        }
        if (sat.isKnown()) {
            this.abox.getCache().putSat(c, sat.isTrue());
        }
        return sat;
    }

    @Override
    public void restoreLocal(Individual ind, Branch br) {
        this.restore(br);
    }

    @Override
    public void restore(Branch br) {
        Timer timer = this.timers.startTimer("restore");
        ++this.abox.stats.globalRestores;
        Node clashNode = this.abox.getClash().getNode();
        List<ATermAppl> clashPath = clashNode.getPath();
        clashPath.add(clashNode.getName());
        this.abox.setBranch(br.getBranch());
        this.abox.setClash(null);
        this.mergeList.clear();
        List<ATermAppl> nodeList = this.abox.getNodeNames();
        if (log.isLoggable(Level.FINE)) {
            log.fine("RESTORE: Branch " + br.getBranch());
            if (br.getNodeCount() < nodeList.size()) {
                log.fine("Remove nodes " + nodeList.subList(br.getNodeCount(), nodeList.size()));
            }
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATermAppl x = nodeList.get(i);
            Node node = this.abox.getNode((ATerm)x);
            if (i >= br.getNodeCount()) {
                this.abox.removeNode(x);
                ATermAppl c = this.cachedNodes.remove(node);
                if (c == null || !PelletOptions.USE_ADVANCED_CACHING) continue;
                if (clashPath.contains(x)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("+++ Cache unsat concept " + c);
                    }
                    this.abox.getCache().putSat(c, false);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("--- Do not cache concept " + c + " " + x + " " + clashNode + " " + clashPath);
                continue;
            }
            node.restore(br.getBranch());
            if (!node.equals(clashNode)) continue;
            this.cachedNodes.remove(node);
        }
        nodeList.subList(br.getNodeCount(), nodeList.size()).clear();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.allValuesRule.apply(ind);
        }
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        timer.stop();
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        ++this.abox.stats.backtracks;
        while (!branchFound) {
            this.completionTimer.check();
            int lastBranch = this.abox.getClash().getDepends().max();
            if (lastBranch <= 0) {
                return false;
            }
            List<Branch> branches = this.abox.getBranches();
            this.abox.stats.backjumps += branches.size() - lastBranch;
            Branch newBranch = null;
            if (lastBranch <= branches.size()) {
                branches.subList(lastBranch, branches.size()).clear();
                newBranch = branches.get(lastBranch - 1);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("JUMP: " + lastBranch);
                }
                if (newBranch == null || lastBranch != newBranch.getBranch()) {
                    throw new RuntimeException("Internal error in reasoner: Trying to backtrack branch " + lastBranch + " but got " + newBranch);
                }
                if (newBranch.getTryNext() < newBranch.getTryCount()) {
                    newBranch.setLastClash(this.abox.getClash().getDepends());
                }
                newBranch.setTryNext(newBranch.getTryNext() + 1);
                if (newBranch.getTryNext() < newBranch.getTryCount()) {
                    this.restore(newBranch);
                    branchFound = newBranch.tryNext();
                }
            }
            if (!branchFound) {
                this.abox.getClash().getDepends().remove(lastBranch);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("FAIL: " + lastBranch);
                continue;
            }
            this.mayNeedExpanding = new LinkedList(this.mnx.get(newBranch.getBranch()));
            this.mnx.subList(newBranch.getBranch() + 1, this.mnx.size()).clear();
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("MNX : " + this.mayNeedExpanding);
        }
        this.abox.validate();
        return branchFound;
    }

    @Override
    public void addBranch(Branch newBranch) {
        super.addBranch(newBranch);
        assert (this.mnx.size() == newBranch.getBranch()) : this.mnx.size() + " != " + newBranch.getBranch();
        this.mnx.add(new ArrayList<Individual>(this.mayNeedExpanding));
    }
}

