/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.blocking.BlockingFactory;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SROIQIncStrategy
extends SROIQStrategy {
    public SROIQIncStrategy(ABox abox) {
        super(abox);
    }

    @Override
    public Iterator<Individual> getInitializeIterator() {
        return this.abox.getIncrementalChangeTracker().updatedIndividuals();
    }

    public Iterator<Individual> getNewIterator() {
        return this.abox.getIncrementalChangeTracker().newIndividuals();
    }

    public Iterator<Edge> getNewEdgeIterator() {
        return this.abox.getIncrementalChangeTracker().newEdges();
    }

    public Iterator<Node> getUnPrunedIterator() {
        return this.abox.getIncrementalChangeTracker().unprunedNodes();
    }

    public Iterator<Edge> getRemovedEdgeIterator() {
        return this.abox.getIncrementalChangeTracker().deletedEdges();
    }

    public Iterator<Map.Entry<Node, Set<ATermAppl>>> getRemovedTypeIterator() {
        return this.abox.getIncrementalChangeTracker().deletedTypes();
    }

    @Override
    public void initialize(Expressivity expr) {
        Edge e;
        QueueElement qe;
        Node obj;
        Individual subj;
        Individual n;
        Timer t = this.abox.getKB().timers.startTimer("initialize");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize Started");
        }
        this.mergeList = new ArrayList();
        this.blocking = BlockingFactory.createBlocking(expr);
        this.configureTableauRules(expr);
        for (Branch branch : this.abox.getBranches()) {
            branch.setStrategy(this);
        }
        this.abox.setBranch(0);
        this.mergeList.addAll(this.abox.getToBeMerged());
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        Iterator<Individual> newIt = this.getNewIterator();
        while (newIt.hasNext()) {
            n = newIt.next();
            if (n.isMerged()) continue;
            this.applyUniversalRestrictions(n);
            this.unfoldingRule.apply(n);
            this.selfRule.apply(n);
        }
        Iterator<Object> it = this.getInitializeIterator();
        while (it.hasNext()) {
            n = it.next();
            this.nominalRule.apply(n);
            if (n.isMerged()) {
                n = n.getSame();
            }
            this.allValuesRule.apply(n);
        }
        it = this.getNewEdgeIterator();
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            subj = edge.getFrom();
            obj = edge.getTo();
            if (subj.isMerged()) {
                subj.getSame();
            }
            if (subj.isPruned()) continue;
            if (obj.isMerged()) {
                obj.getSame();
            }
            if (obj.isPruned()) continue;
            Role pred = edge.getRole();
            DependencySet ds = edge.getDepends();
            this.applyDomainRange(subj, pred, obj, ds);
            if (subj.isPruned() || obj.isPruned()) {
                return;
            }
            this.applyFunctionality(subj, pred, obj);
            if (subj.isPruned() || obj.isPruned()) {
                return;
            }
            if (pred.isObjectRole()) {
                Individual o = (Individual)obj;
                this.checkReflexivitySymmetry(subj, pred, o, ds);
                this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
            }
            if (!this.abox.getKB().getExpressivity().hasCardinality()) continue;
            this.updateQueueAddEdge(subj, pred, obj);
        }
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        this.abox.setBranch(this.abox.getBranches().size() + 1);
        Iterator<Edge> i = this.getRemovedEdgeIterator();
        while (i.hasNext()) {
            Edge e2 = i.next();
            subj = e2.getFrom();
            obj = e2.getTo();
            subj = subj.getSame();
            subj.applyNext[2] = 0;
            subj.applyNext[4] = 0;
            qe = new QueueElement(subj);
            this.abox.getCompletionQueue().add(qe, NodeSelector.EXISTENTIAL);
            this.abox.getCompletionQueue().add(qe, NodeSelector.MIN_NUMBER);
            if (!((obj = obj.getSame()) instanceof Individual)) continue;
            Individual objInd = (Individual)obj;
            objInd.applyNext[2] = 0;
            objInd.applyNext[4] = 0;
            qe = new QueueElement(objInd);
            this.abox.getCompletionQueue().add(qe, NodeSelector.EXISTENTIAL);
            this.abox.getCompletionQueue().add(qe, NodeSelector.MIN_NUMBER);
        }
        Iterator<Map.Entry<Node, Set<ATermAppl>>> it2 = this.getRemovedTypeIterator();
        while (it2.hasNext()) {
            Node node = it2.next().getKey();
            if (node.isIndividual()) {
                Individual ind = (Individual)node;
                this.readdConjunctions(ind);
                ind.applyNext[0] = 0;
                ind.applyNext[3] = 0;
                ind.applyNext[1] = 0;
                qe = new QueueElement(ind);
                this.abox.getCompletionQueue().add(qe, NodeSelector.ATOM);
                this.abox.getCompletionQueue().add(qe, NodeSelector.DISJUNCTION);
                this.allValuesRule.apply(ind);
                for (int j = 0; j < ind.getOutEdges().size(); ++j) {
                    e = ind.getOutEdges().edgeAt(j);
                    if (e.getFrom().isPruned() || e.getTo().isPruned()) continue;
                    Role pred = e.getRole();
                    Node obj2 = e.getTo();
                    DependencySet ds = e.getDepends();
                    for (ATermAppl domain : pred.getDomains()) {
                        if (!this.requiredAddType(ind, domain)) continue;
                        if (!PelletOptions.USE_TRACING) {
                            this.addType(ind, domain, ds.union(DependencySet.EMPTY, this.abox.doExplanation()));
                            continue;
                        }
                        this.addType(ind, domain, ds.union(pred.getExplainDomain(domain), this.abox.doExplanation()));
                    }
                    if (!(obj2 instanceof Individual)) continue;
                    Individual objInd = (Individual)obj2;
                    objInd.applyNext[3] = 0;
                    objInd.applyNext[2] = 0;
                    objInd.applyNext[4] = 0;
                    QueueElement qeObj = new QueueElement(objInd);
                    this.abox.getCompletionQueue().add(qeObj, NodeSelector.EXISTENTIAL);
                    this.abox.getCompletionQueue().add(qeObj, NodeSelector.MIN_NUMBER);
                    this.allValuesRule.apply(ind);
                }
            }
            for (int j = 0; j < node.getInEdges().size(); ++j) {
                Edge e3 = node.getInEdges().edgeAt(j);
                if (e3.getFrom().isPruned() || e3.getTo().isPruned()) continue;
                Individual subj2 = e3.getFrom();
                Role pred = e3.getRole();
                DependencySet ds = e3.getDepends();
                for (ATermAppl range : pred.getRanges()) {
                    if (!this.requiredAddType(node, range)) continue;
                    if (!PelletOptions.USE_TRACING) {
                        this.addType(node, range, ds.union(DependencySet.EMPTY, this.abox.doExplanation()));
                        continue;
                    }
                    this.addType(node, range, ds.union(pred.getExplainRange(range), this.abox.doExplanation()));
                }
                subj2.applyNext[3] = 0;
                subj2.applyNext[2] = 0;
                subj2.applyNext[4] = 0;
                QueueElement qe2 = new QueueElement(subj2);
                this.abox.getCompletionQueue().add(qe2, NodeSelector.EXISTENTIAL);
                this.abox.getCompletionQueue().add(qe2, NodeSelector.MIN_NUMBER);
                this.allValuesRule.apply(subj2);
            }
        }
        i = this.getNewEdgeIterator();
        while (i.hasNext()) {
            this.applyPropertyRestrictions(i.next());
        }
        Iterator<Node> nodeIt = this.getUnPrunedIterator();
        while (nodeIt.hasNext()) {
            int j;
            Node n2 = nodeIt.next();
            if (!n2.isIndividual()) continue;
            Individual ind = (Individual)n2;
            for (j = 0; j < 7; ++j) {
                ind.applyNext[j] = 0;
            }
            this.abox.getCompletionQueue().add(new QueueElement(ind));
            this.allValuesRule.apply(ind);
            for (j = 0; j < ind.getOutEdges().size(); ++j) {
                Node obj3;
                e = ind.getOutEdges().edgeAt(j);
                if (!e.getFrom().isPruned() && !e.getTo().isPruned()) {
                    this.applyPropertyRestrictions(e);
                }
                if (!((obj3 = e.getTo()) instanceof Individual)) continue;
                Individual objInd = (Individual)obj3;
                objInd.applyNext[3] = 0;
                this.allValuesRule.apply(objInd);
            }
            for (j = 0; j < ind.getInEdges().size(); ++j) {
                e = ind.getInEdges().edgeAt(j);
                if (!e.getFrom().isPruned() && !e.getTo().isPruned()) {
                    this.applyPropertyRestrictions(e);
                }
                Individual subj3 = e.getFrom();
                subj3.applyNext[3] = 0;
                this.allValuesRule.apply(subj3);
            }
        }
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
        t.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize Ended");
        }
    }

    protected void readdConjunctions(Individual ind) {
        for (ATermAppl conj : ind.getTypes()) {
            if (!ATermUtils.isAnd(conj) || !ind.hasType((ATerm)conj)) continue;
            this.addType(ind, conj, ind.getDepends((ATerm)conj));
        }
    }

    protected boolean requiredAddType(Node node, ATermAppl type) {
        return type != null && (!node.hasType((ATerm)type) || ATermUtils.isAnd(type));
    }

    @Override
    protected void restoreAllValues() {
        IncrementalChangeTracker tracker = this.abox.getIncrementalChangeTracker();
        Iterator<Map.Entry<Node, Set<ATermAppl>>> it = tracker.deletedTypes();
        while (it.hasNext()) {
            Map.Entry<Node, Set<ATermAppl>> entry = it.next();
            Node node = entry.getKey();
            Set<ATermAppl> types = entry.getValue();
            EdgeList av = this.findAllValues(node, types);
            for (int i = 0; i < av.size(); ++i) {
                Edge e = av.edgeAt(i);
                this.allValuesRule.applyAllValues(e.getFrom(), e.getRole(), e.getTo(), e.getDepends());
            }
        }
        Iterator<Node> i = tracker.unprunedNodes();
        while (i.hasNext()) {
            Node node = i.next();
            if (node instanceof Individual) {
                int j;
                Individual ind = (Individual)node;
                for (j = 0; j < 7; ++j) {
                    ind.applyNext[j] = 0;
                }
                this.abox.getCompletionQueue().add(new QueueElement(ind));
                this.allValuesRule.apply(ind);
                for (j = 0; j < ind.getOutEdges().size(); ++j) {
                    Edge e = ind.getOutEdges().edgeAt(j);
                    Node obj = e.getTo();
                    if (!(obj instanceof Individual)) continue;
                    Individual objInd = (Individual)obj;
                    objInd.applyNext[3] = 0;
                    this.allValuesRule.apply(objInd);
                }
            }
            for (int j = 0; j < node.getInEdges().size(); ++j) {
                Edge e = node.getInEdges().edgeAt(j);
                Individual subj = e.getFrom();
                subj.applyNext[3] = 0;
                this.allValuesRule.apply(subj);
            }
        }
    }

    protected EdgeList findAllValues(Node node, Set<ATermAppl> removedTypes) {
        EdgeList edges = new EdgeList();
        for (int i = 0; i < node.getInEdges().size(); ++i) {
            Edge e = node.getInEdges().edgeAt(i);
            edges.addEdgeList(this.findAllValues(node, e.getFrom(), removedTypes, e));
        }
        if (node instanceof Individual) {
            Individual ind = (Individual)node;
            for (int i = 0; i < ind.getOutEdges().size(); ++i) {
                Edge e = ind.getOutEdges().edgeAt(i);
                Node to = e.getTo();
                Role inv = e.getRole().getInverse();
                if (inv == null || !(to instanceof Individual)) continue;
                edges.addEdgeList(this.findAllValues(ind, (Individual)to, removedTypes, new DefaultEdge(inv, (Individual)to, ind, e.getDepends())));
            }
        }
        return edges;
    }

    protected EdgeList findAllValues(Node node, Individual neighbor, Set<ATermAppl> removedTypes, Edge edge) {
        Object role;
        int i;
        EdgeList edges = new EdgeList();
        boolean applicable = false;
        List<ATermAppl> avTypes = neighbor.getTypes(3);
        ArrayList<ATermAppl> applicableRoles = new ArrayList<ATermAppl>();
        for (i = 0; i < avTypes.size(); ++i) {
            ATermAppl avType = avTypes.get(i);
            role = (ATermAppl)avType.getArgument(0);
            ATermAppl type = (ATermAppl)avType.getArgument(1);
            if (edge != null && !edge.getRole().isSubRoleOf(this.abox.getRole((ATerm)role)) || !this.containsType(type, removedTypes)) continue;
            applicable = true;
            applicableRoles.add(type);
        }
        if (!applicable) {
            return edges;
        }
        if (edge == null) {
            for (i = 0; i < applicableRoles.size(); ++i) {
                ATerm p = (ATerm)applicableRoles.get(i);
                role = this.abox.getRole(p);
                edges.addEdgeList(neighbor.getRNeighborEdges((Role)role, node));
            }
        } else {
            edges.addEdge(edge);
        }
        return edges;
    }

    private boolean containsType(ATermAppl type, Set<ATermAppl> removedTypes) {
        boolean contains = false;
        if (ATermUtils.isAnd(type)) {
            ATermList cs = (ATermList)type.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                if (this.containsType(conj, removedTypes)) {
                    contains = true;
                    break;
                }
                cs = cs.getNext();
            }
        } else if (removedTypes.contains(type)) {
            contains = true;
        }
        return contains;
    }
}

