/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.incremental;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.DisjunctionBranch;
import org.mindswap.pellet.tableau.completion.incremental.BranchAddDependency;
import org.mindswap.pellet.tableau.completion.incremental.BranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.ClashDependency;
import org.mindswap.pellet.tableau.completion.incremental.DependencyEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyIndex {
    public static final Logger log = Logger.getLogger(DependencyIndex.class.getName());
    private Map<ATermAppl, DependencyEntry> dependencies = new HashMap<ATermAppl, DependencyEntry>();
    private Map<Branch, Set<BranchDependency>> branchIndex = new HashMap<Branch, Set<BranchDependency>>();
    private Set<ClashDependency> clashIndex = new HashSet<ClashDependency>();
    private KnowledgeBase kb;

    public DependencyIndex(KnowledgeBase kb) {
        this.kb = kb;
    }

    public DependencyIndex(KnowledgeBase kb, DependencyIndex oldIndex) {
        this(kb);
        for (ATermAppl next : oldIndex.getDependencies().keySet()) {
            DependencyEntry entry = oldIndex.getDependencies(next).copy();
            this.dependencies.put(next, entry);
        }
    }

    public DependencyEntry getDependencies(ATermAppl assertion) {
        return this.dependencies.get(assertion);
    }

    protected Map<ATermAppl, DependencyEntry> getDependencies() {
        return this.dependencies;
    }

    public void addTypeDependency(ATermAppl ind, ATermAppl type, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            this.dependencies.get(nextAtom).addTypeDependency(ind, type);
        }
    }

    public void addMergeDependency(ATermAppl ind, ATermAppl mergedTo, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            this.dependencies.get(nextAtom).addMergeDependency(ind, mergedTo);
        }
    }

    public void addEdgeDependency(Edge edge, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            this.dependencies.get(nextAtom).addEdgeDependency(edge);
        }
    }

    public void addBranchAddDependency(Branch branch) {
        for (ATermAppl nextAtom : branch.getTermDepends().getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DependencyIndex- Adding branch add dependency for assertion: " + nextAtom + " -  Branch id [" + branch.getBranch() + "]   ,  Branch [" + branch + "]");
            }
            BranchDependency newDep = this.dependencies.get(nextAtom).addBranchAddDependency(nextAtom, branch.getBranch(), branch);
            if (!this.branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> newS = new HashSet<BranchDependency>();
                newS.add(newDep);
                this.branchIndex.put(branch, newS);
                continue;
            }
            this.branchIndex.get(branch).add(newDep);
        }
    }

    public void addCloseBranchDependency(Branch branch, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            ATermAppl label = null;
            if (branch instanceof DisjunctionBranch) {
                label = ((DisjunctionBranch)branch).getDisjunct(branch.getTryNext());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DependencyIndex- Adding branch remove ds dependency for assertion: " + nextAtom + " -  Branch id [" + branch.getBranch() + "]   ,  Branch [" + branch + "]   on label [" + label + "]  ,    tryNext [" + branch.getTryNext() + "]");
            }
            BranchDependency newDep = this.dependencies.get(nextAtom).addCloseBranchDependency(nextAtom, branch);
            if (!this.branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> newS = new HashSet<BranchDependency>();
                newS.add(newDep);
                this.branchIndex.put(branch, newS);
                continue;
            }
            this.branchIndex.get(branch).add(newDep);
        }
    }

    public void removeDependencies(ATermAppl assertion) {
        this.dependencies.remove(assertion);
    }

    public void removeBranchDependencies(Branch b) {
        Set<BranchDependency> deps = this.branchIndex.get(b);
        if (deps == null) {
            return;
        }
        for (BranchDependency next : deps) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("DependencyIndex: RESTORE causing remove of branch index for assertion: " + next.getAssertion() + " branch dep.: " + next);
            }
            if (!(next instanceof BranchAddDependency)) continue;
            this.dependencies.get(next.getAssertion()).getBranchAdds().remove(next);
        }
    }

    public void setClashDependencies(Clash clash) {
        for (ClashDependency next : this.clashIndex) {
            if (!this.dependencies.containsKey(next.getAssertion())) continue;
            this.dependencies.get(next.getAssertion()).setClash(null);
        }
        this.clashIndex.clear();
        if (clash == null) {
            return;
        }
        for (ATermAppl nextAtom : clash.getDepends().getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this.dependencies.containsKey(nextAtom)) {
                this.dependencies.put(nextAtom, new DependencyEntry());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("  DependencyIndex- Adding clash dependency: Axiom [" + nextAtom + "]   ,  Clash [" + clash + "]");
            }
            ClashDependency newDep = new ClashDependency(nextAtom, clash);
            this.dependencies.get(nextAtom).setClash(newDep);
            this.clashIndex.add(newDep);
        }
    }
}

