/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.queue;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;

public class OptimizedBasicCompletionQueue
extends CompletionQueue {
    protected List<ATermAppl>[] queue;
    protected Set<ATermAppl>[] newQueue;
    protected List<ATermAppl>[] newQueueList;
    protected int[] current;
    protected int[] end;
    protected int[] cutOff;
    protected boolean backtracked;

    public OptimizedBasicCompletionQueue(ABox abox) {
        super(abox);
        int nSelectors = NodeSelector.numSelectors();
        this.queue = new ArrayList[nSelectors];
        this.newQueue = new HashSet[nSelectors];
        this.newQueueList = new ArrayList[nSelectors];
        this.current = new int[nSelectors];
        this.cutOff = new int[nSelectors];
        this.end = new int[nSelectors];
        for (int i = 0; i < nSelectors; ++i) {
            this.queue[i] = new ArrayList<ATermAppl>();
            this.newQueue[i] = new HashSet<ATermAppl>();
            this.newQueueList[i] = new ArrayList<ATermAppl>();
            this.current[i] = 0;
            this.cutOff[i] = 0;
            this.end[i] = 0;
        }
        this.backtracked = false;
    }

    protected void findNext(int type) {
        Node node;
        while (!(this.current[type] >= this.cutOff[type] || (node = this.abox.getNode((ATerm)this.queue[type].get(this.current[type]))) != null && ((node = node.getSame()) instanceof Literal && this.allowLiterals() || node instanceof Individual && !this.allowLiterals()) && !node.isPruned())) {
            int n = type;
            this.current[n] = this.current[n] + 1;
        }
    }

    public boolean hasNext() {
        this.findNext(this.currentType);
        return this.current[this.currentType] < this.cutOff[this.currentType];
    }

    public void restore(int branch) {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            this.queue[i].addAll(this.newQueueList[i]);
            this.newQueue[i].clear();
            this.newQueueList[i].clear();
            this.end[i] = this.queue[i].size();
            this.current[i] = 0;
            this.cutOff[i] = this.end[i];
        }
        this.backtracked = true;
    }

    public Individual next() {
        this.findNext(this.currentType);
        Individual ind = (Individual)this.abox.getNode((ATerm)this.queue[this.currentType].get(this.current[this.currentType]));
        ind = ind.getSame();
        int n = this.currentType;
        this.current[n] = this.current[n] + 1;
        return ind;
    }

    public Node nextLiteral() {
        this.findNext(this.currentType);
        Node node = this.abox.getNode((ATerm)this.queue[this.currentType].get(this.current[this.currentType]));
        node = node.getSame();
        int n = this.currentType;
        this.current[n] = this.current[n] + 1;
        return node;
    }

    public void add(QueueElement x, NodeSelector s) {
        int type = s.ordinal();
        if (!this.newQueue[type].contains(x.getNode())) {
            this.newQueue[type].add(x.getNode());
            this.newQueueList[type].add(x.getNode());
        }
    }

    public void add(QueueElement x) {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            if (this.newQueue[i].contains(x.getNode())) continue;
            this.newQueue[i].add(x.getNode());
            this.newQueueList[i].add(x.getNode());
        }
    }

    public void reset(NodeSelector s) {
        this.currentType = s.ordinal();
        this.cutOff[this.currentType] = this.end[this.currentType];
        this.current[this.currentType] = 0;
    }

    public void incrementBranch(int branch) {
    }

    public OptimizedBasicCompletionQueue copy() {
        OptimizedBasicCompletionQueue copy = new OptimizedBasicCompletionQueue(this.abox);
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            copy.queue[i] = new ArrayList<ATermAppl>(this.queue[i]);
            copy.newQueue[i] = new HashSet<ATermAppl>(this.newQueue[i]);
            copy.newQueueList[i] = new ArrayList<ATermAppl>(this.newQueueList[i]);
            copy.current[i] = this.current[i];
            copy.cutOff[i] = this.cutOff[i];
            copy.end[i] = this.end[i];
        }
        copy.backtracked = this.backtracked;
        copy.setAllowLiterals(this.allowLiterals());
        return copy;
    }

    public void setABox(ABox ab) {
        this.abox = ab;
    }

    public void print(int type) {
        if (type > NodeSelector.numSelectors()) {
            return;
        }
        System.out.println("Queue " + type + ": " + this.queue[type]);
    }

    public void print() {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            System.out.println("Queue " + i + ": " + this.queue[i]);
        }
    }

    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }

    public void flushQueue() {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            if (!this.backtracked && !this.closed) {
                this.queue[i].clear();
            } else if (this.closed && !this.abox.isClosed()) {
                this.closed = false;
            }
            this.queue[i].addAll(this.newQueueList[i]);
            this.newQueue[i].clear();
            this.newQueueList[i].clear();
            this.end[i] = this.queue[i].size();
        }
        this.backtracked = false;
    }

    protected void flushQueue(NodeSelector s) {
        int index = s.ordinal();
        if (index == NodeSelector.UNIVERSAL.ordinal() || !this.backtracked) {
            this.queue[index].clear();
        }
        this.queue[index].addAll(this.newQueueList[index]);
        this.newQueue[index].clear();
        this.newQueueList[index].clear();
        this.end[index] = this.queue[index].size();
    }

    public void clearQueue(NodeSelector s) {
        int index = s.ordinal();
        this.queue[index].clear();
        this.newQueue[index].clear();
        this.newQueueList[index].clear();
        this.end[index] = this.queue[index].size();
    }
}

