/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;

public class DataCardinalityRule
extends AbstractTableauRule {
    public DataCardinalityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DATATYPE, AbstractTableauRule.BlockingType.NONE);
    }

    public void apply(Individual x) {
        Role role;
        ATermAppl r;
        DependencySet ds;
        Collection<Object> existing;
        HashMap dataranges = new HashMap();
        HashMap<ATermAppl, DependencySet> rangeDepends = new HashMap<ATermAppl, DependencySet>();
        for (ATermAppl allDesc : x.getTypes(3)) {
            ATerm rTerm = allDesc.getArgument(0);
            if (rTerm instanceof ATermList) continue;
            ATermAppl r2 = (ATermAppl)rTerm;
            Role role2 = this.strategy.getABox().getRole((ATerm)r2);
            if (!role2.isDatatypeRole()) continue;
            existing = (ArrayList<ATermAppl>)dataranges.get(r2);
            ds = x.getDepends((ATerm)allDesc);
            if (existing == null) {
                existing = new ArrayList<ATermAppl>();
                dataranges.put(r2, existing);
            } else {
                ds = ds.union((DependencySet)rangeDepends.get(r2), this.strategy.getABox().doExplanation());
            }
            existing.add((ATermAppl)allDesc.getArgument(1));
            rangeDepends.put(r2, ds);
        }
        for (ATermAppl minDesc : x.getTypes(4)) {
            Set<ATermAppl> ranges;
            r = (ATermAppl)minDesc.getArgument(0);
            role = this.strategy.getABox().getRole((ATerm)r);
            if (!role.isDatatypeRole() || (ranges = role.getRanges()).isEmpty()) continue;
            existing = (Collection)dataranges.get(r);
            if (existing == null) {
                existing = new ArrayList();
                dataranges.put(r, existing);
                ds = DependencySet.EMPTY;
            } else {
                ds = (DependencySet)rangeDepends.get(r);
            }
            for (ATermAppl dataRange : role.getRanges()) {
                existing.add(dataRange);
                ds = ds.union(role.getExplainRange(dataRange), this.strategy.getABox().doExplanation());
                rangeDepends.put(r, ds);
            }
        }
        for (ATermAppl minDesc : x.getTypes(4)) {
            r = (ATermAppl)minDesc.getArgument(0);
            role = this.strategy.getABox().getRole((ATerm)r);
            HashSet drs = new HashSet();
            Collection direct = (Collection)dataranges.get(r);
            if (direct != null) {
                drs.addAll(direct);
                ds = (DependencySet)rangeDepends.get(r);
            } else {
                ds = DependencySet.EMPTY;
            }
            ds = ds.union(x.getDepends((ATerm)minDesc), this.strategy.getABox().doExplanation());
            for (Role superRole : role.getSuperRoles()) {
                ATermAppl s = superRole.getName();
                Collection inherited = (Collection)dataranges.get(s);
                if (inherited == null) continue;
                drs.addAll(inherited);
                ds = ds.union((DependencySet)rangeDepends.get(s), this.strategy.getABox().doExplanation()).union(role.getExplainSuper((ATerm)s), this.strategy.getABox().doExplanation());
            }
            if (drs.isEmpty()) continue;
            int n = ((ATermInt)minDesc.getArgument(1)).getInt();
            try {
                if (this.strategy.getABox().getDatatypeReasoner().containsAtLeast(n, drs)) continue;
                this.strategy.getABox().setClash(Clash.minMax(x, ds));
                return;
            }
            catch (DatatypeReasonerException e) {
                throw new InternalReasonerException(e);
            }
        }
    }
}

