/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.DisjunctionBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class DisjunctionRule
extends AbstractTableauRule {
    public DisjunctionRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DISJUNCTION, AbstractTableauRule.BlockingType.COMPLETE);
    }

    public void apply(Individual node) {
        if (!node.canApply(1)) {
            return;
        }
        List<ATermAppl> types = node.getTypes(1);
        int size = types.size();
        ATermAppl[] disjunctions = new ATermAppl[size - node.applyNext[1]];
        types.subList(node.applyNext[1], size).toArray(disjunctions);
        if (PelletOptions.USE_DISJUNCTION_SORTING != "NO") {
            DisjunctionRule.sortDisjunctions(node, disjunctions);
        }
        for (ATermAppl disjunction : disjunctions) {
            this.applyDisjunctionRule(node, disjunction);
            if (!this.strategy.getABox().isClosed() && !node.isMerged()) continue;
            return;
        }
        node.applyNext[1] = size;
    }

    private static void sortDisjunctions(final Individual node, ATermAppl[] disjunctions) {
        if (PelletOptions.USE_DISJUNCTION_SORTING != "OLDEST_FIRST") {
            throw new InternalReasonerException("Unknown disjunction sorting option " + PelletOptions.USE_DISJUNCTION_SORTING);
        }
        Comparator<ATermAppl> comparator = new Comparator<ATermAppl>(){

            @Override
            public int compare(ATermAppl d1, ATermAppl d2) {
                return node.getDepends((ATerm)d1).max() - node.getDepends((ATerm)d2).max();
            }
        };
        Arrays.sort(disjunctions, comparator);
    }

    protected void applyDisjunctionRule(Individual node, ATermAppl disjunction) {
        ATermAppl a = (ATermAppl)disjunction.getArgument(0);
        ATermList disjuncts = (ATermList)a.getArgument(0);
        ATermAppl[] disj = new ATermAppl[disjuncts.getLength()];
        int index = 0;
        while (!disjuncts.isEmpty()) {
            disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
            if (node.hasType((ATerm)disj[index])) {
                return;
            }
            disjuncts = disjuncts.getNext();
            ++index;
        }
        DisjunctionBranch newBranch = new DisjunctionBranch(this.strategy.getABox(), this.strategy, node, disjunction, node.getDepends((ATerm)disjunction), disj);
        this.strategy.addBranch(newBranch);
        newBranch.tryNext();
    }
}

