/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class SomeValuesRule
extends AbstractTableauRule {
    public SomeValuesRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.EXISTENTIAL, AbstractTableauRule.BlockingType.COMPLETE);
    }

    public void apply(Individual x) {
        if (!x.canApply(2)) {
            return;
        }
        List<ATermAppl> types = x.getTypes(2);
        int size = types.size();
        for (int j = x.applyNext[2]; j < size; ++j) {
            ATermAppl sv = types.get(j);
            this.applySomeValuesRule(x, sv);
            if (!this.strategy.getABox().isClosed() && !x.isPruned()) continue;
            return;
        }
        x.applyNext[2] = size;
    }

    protected void applySomeValuesRule(Individual x, ATermAppl sv) {
        ATermAppl a = (ATermAppl)sv.getArgument(0);
        ATermAppl s = (ATermAppl)a.getArgument(0);
        ATermAppl c = (ATermAppl)a.getArgument(1);
        DependencySet ds = x.getDepends((ATerm)sv);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        c = ATermUtils.negate(c);
        if (s.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            if (ATermUtils.isNominal(c)) {
                return;
            }
            for (Node node : this.strategy.getABox().getNodes()) {
                if (!node.isIndividual() || node.isPruned() || !node.hasType((ATerm)c)) continue;
                return;
            }
            Individual y = this.strategy.createFreshIndividual(x, ds);
            this.strategy.addType(y, c, ds);
            return;
        }
        Role role = this.strategy.getABox().getRole((ATerm)s);
        boolean neighborFound = false;
        boolean neighborSafe = x.isBlockable();
        Node y = null;
        Edge edge2 = null;
        EdgeList edges = x.getRNeighborEdges(role);
        for (Edge edge2 : edges) {
            y = edge2.getNeighbor(x);
            if (PelletOptions.USE_COMPLETION_QUEUE && y.isPruned()) {
                y = null;
                continue;
            }
            if (!y.hasType((ATerm)c) || !(neighborFound = neighborSafe || y.isLiteral() || !this.strategy.getBlocking().isBlocked((Individual)y))) continue;
        }
        if (neighborFound) {
            return;
        }
        if (role.isDatatypeRole()) {
            Literal literal = (Literal)y;
            if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
                ATermAppl canonical;
                this.strategy.getABox().copyOnWrite();
                ATermAppl input = (ATermAppl)c.getArgument(0);
                if (input.getArgument(2).equals((Object)ATermUtils.NO_DATATYPE)) {
                    canonical = input;
                } else {
                    try {
                        canonical = this.strategy.getABox().getDatatypeReasoner().getCanonicalRepresentation(input);
                    }
                    catch (InvalidLiteralException e) {
                        String msg = "Invalid literal encountered in nominal when attempting to apply some values rule: " + e.getMessage();
                        throw new InternalReasonerException(msg, e);
                    }
                    catch (UnrecognizedDatatypeException e) {
                        String msg = "Unrecognized datatype for literal encountered in nominal when attempting to apply some values rule: " + e.getMessage();
                        throw new InternalReasonerException(msg, e);
                    }
                }
                literal = this.strategy.getABox().addLiteral(canonical);
            } else {
                if (!role.isFunctional() || literal == null) {
                    literal = this.strategy.getABox().addLiteral(ds);
                } else {
                    ds = ds.union(role.getExplainFunctional(), this.strategy.getABox().doExplanation());
                    ds = ds.union(edge2.getDepends(), this.strategy.getABox().doExplanation());
                }
                this.strategy.addType(literal, c, ds);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("SOME: " + x + " -> " + s + " -> " + literal + " : " + ATermUtils.toString(c) + " - " + ds);
            }
            this.strategy.addEdge(x, role, literal, ds);
        } else if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
            this.strategy.getABox().copyOnWrite();
            ATermAppl value = (ATermAppl)c.getArgument(0);
            y = this.strategy.getABox().getIndividual((ATerm)value);
            if (log.isLoggable(Level.FINE)) {
                log.fine("VAL : " + x + " -> " + ATermUtils.toString(s) + " -> " + y + " - " + ds);
            }
            if (y == null) {
                if (ATermUtils.isAnonNominal(value)) {
                    y = this.strategy.getABox().addIndividual(value, ds);
                } else {
                    if (ATermUtils.isLiteral(value)) {
                        throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction " + "where the value is a literal: " + ATermUtils.toString(value));
                    }
                    throw new InternalReasonerException("Nominal " + c + " is not found in the KB!");
                }
            }
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this.strategy.getABox().doExplanation());
                y = y.getSame();
            }
            this.strategy.addEdge(x, role, y, ds);
        } else {
            DependencySet maxCardDS;
            boolean useExistingNode = false;
            boolean useExistingRole = false;
            DependencySet dependencySet = maxCardDS = role.isFunctional() ? role.getExplainFunctional() : x.hasMax1(role);
            if (maxCardDS != null) {
                ds = ds.union(maxCardDS, this.strategy.getABox().doExplanation());
                if (edge2 != null) {
                    useExistingNode = true;
                    useExistingRole = true;
                } else {
                    Set<Role> fs = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                    for (Role f : fs) {
                        edges = x.getRNeighborEdges(f);
                        if (edges.isEmpty()) continue;
                        if (useExistingNode) {
                            DependencySet fds = DependencySet.INDEPENDENT;
                            if (PelletOptions.USE_TRACING) {
                                fds = role.isFunctional() ? role.getExplainSuper((ATerm)f.getName()) : role.getExplainSub((ATerm)f.getName());
                            }
                            Edge otherEdge = edges.edgeAt(0);
                            Node otherNode = otherEdge.getNeighbor(x);
                            DependencySet d = ds.union(edge2.getDepends(), this.strategy.getABox().doExplanation()).union(otherEdge.getDepends(), this.strategy.getABox().doExplanation()).union(fds, this.strategy.getABox().doExplanation());
                            this.strategy.mergeTo(y, otherNode, d);
                            continue;
                        }
                        useExistingNode = true;
                        edge2 = edges.edgeAt(0);
                        y = edge2.getNeighbor(x);
                    }
                    if (y != null) {
                        y = y.getSame();
                    }
                }
            }
            if (useExistingNode) {
                ds = ds.union(edge2.getDepends(), this.strategy.getABox().doExplanation());
            } else {
                y = this.strategy.createFreshIndividual(x, ds);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("SOME: " + x + " -> " + role + " -> " + y + " : " + ATermUtils.toString(c) + (useExistingNode ? "" : " (*)") + " - " + ds);
            }
            this.strategy.addType(y, c, ds);
            if (!useExistingRole) {
                if (x.isBlockable() && y.isConceptRoot()) {
                    this.strategy.addEdge((Individual)y, role.getInverse(), x, ds);
                } else {
                    this.strategy.addEdge(x, role, y, ds);
                }
            }
        }
    }
}

