/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Unfolding {
    public abstract ATermAppl getCondition();

    public abstract Set<ATermAppl> getExplanation();

    public abstract ATermAppl getResult();

    public static Unfolding create(ATermAppl result, Set<ATermAppl> explanation) {
        return new Unconditional(result, explanation);
    }

    public static Unfolding create(ATermAppl result, ATermAppl condition, Set<ATermAppl> explanation) {
        return new Conditional(result, condition, explanation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Conditional
    extends Unconditional {
        private ATermAppl condition;

        private Conditional(ATermAppl result, ATermAppl condition, Set<ATermAppl> explanation) {
            super(result, explanation);
            this.condition = condition;
        }

        @Override
        public ATermAppl getCondition() {
            return this.condition;
        }

        @Override
        public String toString() {
            return ATermUtils.toString(this.condition) + " ? " + ATermUtils.toString(this.getResult());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Unconditional
    extends Unfolding {
        private ATermAppl result;
        private Set<ATermAppl> explanation;

        private Unconditional(ATermAppl result, Set<ATermAppl> explanation) {
            this.result = result;
            this.explanation = explanation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Unfolding)) {
                return false;
            }
            Unconditional other = (Unconditional)obj;
            return this.getCondition().equals(other.getCondition()) && this.explanation.equals(other.explanation) && this.result.equals(other.result);
        }

        @Override
        public ATermAppl getCondition() {
            return ATermUtils.TOP;
        }

        @Override
        public Set<ATermAppl> getExplanation() {
            return this.explanation;
        }

        @Override
        public ATermAppl getResult() {
            return this.result;
        }

        public int hashCode() {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.getCondition().hashCode();
            hashCode = 31 * hashCode + this.explanation.hashCode();
            hashCode = 31 * hashCode + this.result.hashCode();
            return hashCode;
        }

        public String toString() {
            return ATermUtils.toString(this.result);
        }
    }
}

