/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueMap<K, V>
extends HashMap<K, Set<V>>
implements Map<K, Set<V>> {
    private static final long serialVersionUID = 2660982967886888197L;

    public MultiValueMap() {
    }

    public MultiValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public Set<V> putSingle(K key, V value) {
        HashSet<V> set = new HashSet<V>();
        set.add(value);
        return super.put(key, set);
    }

    @Override
    public Set<V> put(K key, Set<V> values) {
        return super.put(key, values);
    }

    public boolean add(K key, V value) {
        HashSet<V> values = (HashSet<V>)this.get(key);
        if (values == null) {
            values = new HashSet<V>();
            super.put(key, values);
        }
        return values.add(value);
    }

    public boolean addAll(K key, Collection<? extends V> collection) {
        HashSet<? extends V> values = (HashSet<? extends V>)this.get(key);
        if (values == null) {
            values = new HashSet<V>();
            super.put(key, values);
        }
        return values.addAll(collection);
    }

    @Override
    public boolean remove(K key, V value) {
        boolean removed = false;
        Set values = (Set)this.get(key);
        if (values != null) {
            removed = values.remove(value);
            if (values.isEmpty()) {
                super.remove(key);
            }
        }
        return removed;
    }

    public boolean contains(K key, V value) {
        Set values = (Set)this.get(key);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    public Iterator<V> flattenedValues() {
        return new Iterator<V>(){
            private Iterator<Set<V>> setIterator;
            private Iterator<V> valueIterator;
            {
                this.setIterator = MultiValueMap.this.values().iterator();
                this.valueIterator = null;
            }

            @Override
            public boolean hasNext() {
                while (this.valueIterator == null || !this.valueIterator.hasNext()) {
                    if (!this.setIterator.hasNext()) {
                        return false;
                    }
                    this.valueIterator = this.setIterator.next().iterator();
                }
                return true;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.valueIterator.next();
            }

            @Override
            public void remove() {
                this.setIterator.remove();
            }
        };
    }
}

