/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedIterator<Outer, Inner>
implements Iterator<Inner> {
    private Iterator<? extends Outer> outerIterator;
    private Iterator<? extends Inner> innerIterator;

    public NestedIterator(Iterable<? extends Outer> outerIterable) {
        this(outerIterable.iterator());
    }

    public NestedIterator(Iterator<? extends Outer> outerIterator) {
        this.outerIterator = outerIterator;
        this.findIterator();
    }

    private void findIterator() {
        while (this.outerIterator.hasNext()) {
            Outer subj = this.outerIterator.next();
            this.innerIterator = this.getInnerIterator(subj);
            if (!this.innerIterator.hasNext()) continue;
            return;
        }
        this.innerIterator = IteratorUtils.emptyIterator();
    }

    public abstract Iterator<? extends Inner> getInnerIterator(Outer var1);

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public Inner next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Inner value = this.innerIterator.next();
        if (!this.innerIterator.hasNext()) {
            this.findIterator();
        }
        return value;
    }

    @Override
    public void remove() {
        this.innerIterator.remove();
    }
}

