/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.progress;

import java.io.PrintStream;
import org.mindswap.pellet.utils.DurationFormat;
import org.mindswap.pellet.utils.progress.AbstractProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

public class ConsoleProgressMonitor
extends AbstractProgressMonitor
implements ProgressMonitor {
    private PrintStream out;

    public ConsoleProgressMonitor() {
        this(System.err, 0);
    }

    public ConsoleProgressMonitor(PrintStream out) {
        this(out, 0);
    }

    public ConsoleProgressMonitor(int length) {
        this(System.err, length);
    }

    public ConsoleProgressMonitor(PrintStream out, int length) {
        this.out = out;
        this.setProgressLength(length);
        this.setProgressTitle("");
    }

    protected void resetProgress() {
        super.resetProgress();
    }

    public void taskStarted() {
        super.taskStarted();
        this.out.println(this.progressTitle + " " + this.progressLength + " elements");
    }

    protected void updateProgress() {
        int pc = (int)(100.0 * (double)this.progress / (double)this.progressLength);
        if (pc == this.progressPercent) {
            return;
        }
        this.progressPercent = pc;
        this.out.print('\r');
        this.out.print(this.progressTitle);
        this.out.print(": ");
        this.out.print(this.progressMessage);
        this.out.print(" ");
        this.out.print(this.progressPercent);
        this.out.print("% complete in ");
        this.out.print(DurationFormat.SHORT.format(this.timer.getElapsed()));
    }

    @Deprecated
    public String calcElapsedTime() {
        return DurationFormat.SHORT.format(this.timer.getElapsed());
    }

    public void taskFinished() {
        super.taskFinished();
        this.setProgress(this.progressLength);
        this.out.println();
        this.out.print(this.progressTitle);
        this.out.print(" finished in ");
        this.out.println(DurationFormat.SHORT.format(this.timer.getLast()));
    }
}

