# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Configuration
  CFG_COMMON = {
    :"runner.read_timestamp" => "20150106 161637 +0100",

    :"log.developer_mode" => true,
    :"log.threaded" => false,
    :"log.loglevel" => Ghun::Log::Level::DEBUG,
    :"log.tll.loglevel" => Ghun::Log::Level::DEBUG,

    :"log.storage.file.enabled" => true,
    :"log.storage.file.loglevel" => Ghun::Log::Level::ALL,
    :"log.storage.file.logsource" => Ghun::Log::Source::ALL,
    :"log.storage.file.logtype" => Ghun::Log::Type::ALL,

    :"log.storage.stdout.enabled" => true,
    :"log.storage.stdout.loglevel" => Ghun::Log::Level::INFO,
    :"log.storage.stdout.logsource" => Ghun::Log::Source::ALL,
    :"log.storage.stdout.logtype" => Ghun::Log::Type::ALL,

    :"log.storage.stderr.enabled" => true,
    :"log.storage.stderr.loglevel" => Ghun::Log::Level::WARN,
    :"log.storage.stderr.logsource" => Ghun::Log::Source::ALL,
    :"log.storage.stderr.logtype" => Ghun::Log::Type::ALL,

    :"log.queue" => ["error","timing","development_full","remote.err","report"],
    :"log.queue.development_full.enabled" => false,
    :"log.queue.development_full.only_developer" => true,
    :"log.queue.development_full.loglevel" => Ghun::Log::Level::ALL,
    :"log.queue.development_full.logsource" => Ghun::Log::Source::ALL,
    :"log.queue.development_full.logtype" => Ghun::Log::Type::ALL,
    :"log.queue.development_full.storage" => ["file"],

    :"log.queue.report.enabled" => false,
    :"log.queue.report.only_developer" => false,
    :"log.queue.report.loglevel" => Ghun::Log::Level::ALL,
    :"log.queue.report.logsource" => Ghun::Log::Source::ALL,
    :"log.queue.report.logtype" => Ghun::Log::Type::REPORT,
    :"log.queue.report.storage" => ["file"],

    :"log.queue.remote.err.enabled" => true,
    :"log.queue.remote.err.only_developer" => false,
    :"log.queue.remote.err.loglevel" => Ghun::Log::Level::WARN,
    :"log.queue.remote.err.logsource" => Ghun::Log::Source::REMOTE | Ghun::Log::Source::TARGET | Ghun::Log::Source::DNS,
    :"log.queue.remote.err.logtype" => Ghun::Log::Type::ALL,
    :"log.queue.remote.err.storage" => ["file"],

    :"log.queue.error.enabled" => true,
    :"log.queue.error.only_developer" => false,
    :"log.queue.error.loglevel" => Ghun::Log::Level::WARN,
    :"log.queue.error.logsource" => Ghun::Log::Source::ALL^(Ghun::Log::Source::REMOTE | Ghun::Log::Source::TARGET | Ghun::Log::Source::DNS),
    :"log.queue.error.logtype" => Ghun::Log::Type::ALL,
    :"log.queue.error.storage" => ["stderr","file"],

    :"log.queue.timing.enabled" => true,
    :"log.queue.timing.only_developer" => true,
    :"log.queue.timing.loglevel" => Ghun::Log::Level::ALL,
    :"log.queue.timing.logsource" => Ghun::Log::Source::ALL,
    :"log.queue.timing.logtype" => Ghun::Log::Type::TIMING | Ghun::Log::Type::PROFILING,
    :"log.queue.timing.storage" => ["file"],

    :"dns.force_tcp" => true,
    :"dns.allow_caching" => true,

    :"ontology.namespace" => ['rdf','rdfs','owl','list','dc','xsd','no'],
    :"ontology.default_namespace" => 'no',
    :"ontology.namespace.rdf" => "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
    :"ontology.namespace.rdfs" => "http://www.w3.org/2000/01/rdf-schema#",
    :"ontology.namespace.owl" => "http://www.w3.org/2002/07/owl#",
    :"ontology.namespace.list" => "http://jena.hpl.hp.com/ARQ/list#",
    :"ontology.namespace.dc" => "http://purl.org/dc/elements/1.1/",
    :"ontology.namespace.xsd" => "http://www.w3.org/2001/XMLSchema#",
    :"ontology.namespace.no" => "http://dev.tzi.org/io/network.owl#",

#    :"ontology.query.engine" => "jena",
#    :"ontology.query.structure_file" => File.join(Ghun::Base::Blackboard.application.data_path,'ontologies','network.owl'),
#    :"ontology.query.storage_backend" => "tdb",
#    :"ontology.query.read_only" => false,
#    :"ontology.query.storage_file" => File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network.owl'),
#    :"ontology.query.storage_dir" => File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network'),
#    :"ontology.query.startup_type" => "full",

    :"ontology.query.engine" => "jena",
    :"ontology.query.structure_file" => File.join(Ghun::Base::Blackboard.application.data_path,'ontologies','network.owl'),
    :"ontology.query.storage_backend" => "file",
    :"ontology.query.read_only" => true,
    :"ontology.query.storage_file" => File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network.owl'),
    :"ontology.query.storage_dir" => File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network'),
    :"ontology.query.startup_type" => "full",

    :"ontology.change0.engine" => "jena",
    :"ontology.change0.structure_file" => File.join(Ghun::Base::Blackboard.application.data_path,'ontologies','network.owl'),
    :"ontology.change0.storage_backend" => "file",
    :"ontology.change0.read_only" => true,
    :"ontology.change0.storage_file" => File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network.section1.owl'),
    :"ontology.change0.startup_type" => "full",

    :"ontology.writer.engine" => "jena",
    :"ontology.writer.structure_file" => File.join(Ghun::Base::Blackboard.application.data_path,'ontologies','network.owl'),
    :"ontology.writer.storage_backend" => "file",
    :"ontology.writer.read_only" => false,
    :"ontology.writer.storage_file" => File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network.owl'),
    :"ontology.writer.startup_type" => "fastwrite",

    :"ontology.mapper.engine" => "jena",
    :"ontology.mapper.structure_file" => File.join(Ghun::Base::Blackboard.application.data_path,'ontologies','network.owl'),
    :"ontology.mapper.storage_backend" => "file",
    :"ontology.mapper.read_only" => true,
    :"ontology.mapper.startup_type" => "mapper",

    :"runner.sleeping_thread_compensation_factor" => 2,
    :"target.vlan_name_distribution_report" => false,
  }
end

